/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.ritual;

import com.bewitchment.Bewitchment;
import com.bewitchment.Util;
import com.bewitchment.api.message.SpawnParticle;
import com.bewitchment.api.registry.Ritual;
import com.bewitchment.common.item.tool.ItemBoline;
import com.bewitchment.common.world.BiomeChangingUtils;
import com.bewitchment.registry.ModObjects;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class RitualBiomeShift
extends Ritual {
    private int biome;

    public RitualBiomeShift() {
        super(Util.newResource("biome_shift"), Arrays.asList(Util.get("treeSapling"), Util.get("logWood"), Util.get(ModObjects.oak_apple_gall), Util.get(ModObjects.oak_apple_gall), Util.get(ModObjects.pentacle), Util.get(new ItemStack(ModObjects.oak_spirit)), Util.get(new ItemStack(ModObjects.dimensional_sand)), Util.get(new ItemStack(ModObjects.boline))), null, null, true, 50, 1300, 33, 3, 3, 3);
    }

    @Override
    public void read() {
        super.read();
        this.biome = this.nbt.func_74762_e("biome");
    }

    @Override
    public void write() {
        super.write();
        this.nbt.func_74768_a("biome", this.biome);
    }

    @Override
    public boolean isValid(World world, BlockPos altarPos, EntityPlayer caster, ItemStackHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemBoline)) continue;
            this.biome = stack.func_77978_p().func_74762_e("biome_id");
            return super.isValid(world, altarPos, caster, inventory) && this.biome > 0;
        }
        return false;
    }

    @Override
    public void onUpdate(World world, BlockPos altarPos, BlockPos effectivePos, EntityPlayer caster, ItemStackHandler inventory) {
        Random rand = world.field_73012_v;
        double cx = (double)effectivePos.func_177958_n() + 0.5;
        double cy = (double)effectivePos.func_177956_o() + 0.5;
        double cz = (double)effectivePos.func_177952_p() + 0.5;
        for (int i = 0; i < 15; ++i) {
            double sx = cx + rand.nextGaussian() * 0.5;
            double sy = cy + rand.nextGaussian() * 0.5;
            double sz = cz + rand.nextGaussian() * 0.5;
            Bewitchment.network.sendToDimension((IMessage)new SpawnParticle(EnumParticleTypes.ENCHANTMENT_TABLE, sx, sy, sz, 0.6 * (sx - cx), 0.6 * (sy - cy), 0.6 * (sz - cz)), world.field_73011_w.getDimension());
        }
    }

    @Override
    public void onFinished(World world, BlockPos altarPos, BlockPos effectivePos, EntityPlayer caster, ItemStackHandler inventory) {
        int radius = 32;
        for (double x = (double)(-radius); x < (double)radius; x += 1.0) {
            for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                if (!(Math.sqrt(x * x + z * z) < (double)radius)) continue;
                BlockPos pos = effectivePos.func_177963_a(x, 0.0, z);
                BiomeChangingUtils.setBiome(world, pos, this.biome);
                BiomeChangingUtils.updateBiomeOnClient(world, pos, this.biome, radius);
            }
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            inventory.extractItem(i, 1, false);
        }
    }
}

