/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.entity.spirit.ghost;

import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.common.block.BlockCandelabra;
import com.bewitchment.common.entity.util.ModEntityMob;
import com.bewitchment.registry.ModObjects;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityGhost
extends ModEntityMob {
    private boolean charging = false;

    public EntityGhost(World world) {
        super(world, new ResourceLocation("bewitchment", "entities/ghost"));
        this.field_70178_ae = true;
        this.field_70728_aV = 35;
        this.field_70765_h = new AIMoveControl(this);
    }

    private boolean canApproach(World world, BlockPos pos) {
        for (BlockPos current : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-8, -8, -8), (BlockPos)pos.func_177982_a(8, 8, 8))) {
            IBlockState state = world.func_180495_p(current);
            if (Math.abs(current.func_177958_n() - pos.func_177958_n()) < 4 && Math.abs(current.func_177952_p() - pos.func_177952_p()) < 4 && state.func_177230_c() == ModObjects.salt_barrier) {
                return false;
            }
            if (!(state.func_177230_c() instanceof BlockCandelabra) || !((Boolean)state.func_177229_b((IProperty)BlockCandelabra.LIT)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean isCharging() {
        return this.charging;
    }

    private void setCharging(boolean charging) {
        this.charging = charging;
    }

    @Override
    protected int getSkinTypes() {
        return 5;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 0 && !this.canApproach(this.field_70170_p, this.func_180425_c())) {
            this.func_70624_b(null);
        }
    }

    @Override
    protected boolean func_70814_o() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72896_J() && this.func_70692_ba()) {
            this.func_70106_y();
        }
    }

    protected boolean func_70692_ba() {
        return !this.func_145818_k_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntityGhost.class}));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, false, false, e -> e instanceof EntityVillager || e instanceof AbstractIllager || e instanceof EntityWitch || e instanceof EntityIronGolem));
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(300);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public int func_70641_bl() {
        return 6;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_188419_a() != MobEffects.field_76436_u && effect.func_188419_a() != MobEffects.field_82731_v && super.func_70687_e(effect);
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return BewitchmentAPI.SPIRIT;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        this.func_189654_d(true);
        this.field_70145_X = true;
        super.func_191986_a(strafe, vertical, forward);
    }

    public boolean shouldRenderInPass(int pass) {
        if (pass == 1) {
            return true;
        }
        return super.shouldRenderInPass(pass);
    }

    class AIChargeAttack
    extends EntityAIBase {
        private AIChargeAttack() {
            this.func_75248_a(1);
        }

        private double getAttackReachSqr(EntityLivingBase attackTarget) {
            return EntityGhost.this.field_70130_N * 2.0f * EntityGhost.this.field_70130_N * 2.0f + attackTarget.field_70130_N;
        }

        public boolean func_75250_a() {
            if (EntityGhost.this.func_70638_az() != null && !EntityGhost.this.func_70605_aq().func_75640_a() && EntityGhost.this.field_70146_Z.nextInt(7) == 0) {
                return EntityGhost.this.func_70068_e((Entity)EntityGhost.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityGhost.this.func_70605_aq().func_75640_a() && EntityGhost.this.isCharging() && EntityGhost.this.func_70638_az() != null && EntityGhost.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityGhost.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityGhost.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityGhost.this.setCharging(true);
        }

        public void func_75251_c() {
            EntityGhost.this.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityGhost.this.func_70638_az();
            if (entitylivingbase != null) {
                if (EntityGhost.this.func_70068_e((Entity)entitylivingbase) <= this.getAttackReachSqr(entitylivingbase)) {
                    EntityGhost.this.func_70652_k((Entity)entitylivingbase);
                    EntityGhost.this.setCharging(false);
                } else {
                    double d0 = EntityGhost.this.func_70068_e((Entity)entitylivingbase);
                    if (d0 < 12.0) {
                        Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                        EntityGhost.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                    }
                }
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        private AIMoveControl(EntityGhost ghost) {
            super((EntityLiving)ghost);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityGhost.this.field_70165_t;
                double d1 = this.field_75647_c - EntityGhost.this.field_70163_u;
                double d2 = this.field_75644_d - EntityGhost.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityGhost.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityGhost tempGhost = EntityGhost.this;
                    tempGhost.field_70159_w *= 0.5;
                    tempGhost = EntityGhost.this;
                    tempGhost.field_70181_x *= 0.5;
                    tempGhost = EntityGhost.this;
                    tempGhost.field_70179_y *= 0.5;
                } else {
                    EntityGhost tempGhost = EntityGhost.this;
                    tempGhost.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    tempGhost = EntityGhost.this;
                    tempGhost.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    tempGhost = EntityGhost.this;
                    tempGhost.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityGhost.this.func_70638_az() == null) {
                        EntityGhost.this.field_70761_aq = EntityGhost.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityGhost.this.field_70159_w, (double)EntityGhost.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityGhost.this.func_70638_az().field_70165_t - EntityGhost.this.field_70165_t;
                        double d5 = EntityGhost.this.func_70638_az().field_70161_v - EntityGhost.this.field_70161_v;
                        EntityGhost.this.field_70761_aq = EntityGhost.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityGhost.this.func_70605_aq().func_75640_a() && EntityGhost.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityGhost.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityGhost.this.field_70146_Z.nextInt(15) - 7, EntityGhost.this.field_70146_Z.nextInt(7) - 3, EntityGhost.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityGhost.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityGhost.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityGhost.this.func_70638_az() != null) break;
                EntityGhost.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

