/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.util;

import com.bewitchment.Util;
import com.bewitchment.common.block.BlockWitchesAltar;
import com.bewitchment.common.block.tile.entity.TileEntityWitchesCauldron;
import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.common.block.tile.entity.util.TileEntityAltarStorage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ModBlockContainer
extends BlockContainer {
    private final Object modInstance;
    private final int guiID;

    protected ModBlockContainer(Object modInstance, String name, Material mat, SoundType sound, float hardness, float resistance, String tool, int guiID) {
        super(mat);
        Util.registerBlock(this, name, mat, sound, hardness, resistance, tool, 0, new String[0]);
        this.modInstance = modInstance;
        this.guiID = guiID;
    }

    protected ModBlockContainer(Object modInstance, String name, Block base, int guiID) {
        super(base.func_176223_P().func_185904_a());
        Util.registerBlock(this, name, base, new String[0]);
        this.modInstance = modInstance;
        this.guiID = guiID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && this.hasTileEntity(state) && world.func_175625_s(pos) instanceof ModTileEntity && !(world.func_175625_s(pos) instanceof TileEntityWitchesCauldron)) {
            ModTileEntity tile = (ModTileEntity)world.func_175625_s(pos);
            for (ItemStackHandler inventory : tile.getInventories()) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inventory.getStackInSlot(i));
                }
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return (!Util.isTransparent(state) || world.func_180495_p(pos.func_177972_a(face)).func_177230_c() != this) && super.func_176225_a(state, world, pos, face);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Util.isTransparent(this.func_176223_P()) ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (this.guiID > -1) {
                player.openGui(this.modInstance, this.guiID, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            if (world.func_175625_s(pos) instanceof ModTileEntity) {
                return ((ModTileEntity)world.func_175625_s(pos)).activate(world, pos, player, hand, face);
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, face, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.refreshAltarPos((IBlockAccess)world, pos);
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185904_a() == Material.field_151575_d;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151575_d;
    }

    public void refreshAltarPos(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAltarStorage) {
            ((TileEntityAltarStorage)tile).altarPos = BlockWitchesAltar.getNearestAltarPos(world, pos);
        }
    }
}

