/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.capability.extendedworld;

import com.bewitchment.Bewitchment;
import com.bewitchment.api.message.SyncExtendedWorld;
import com.bewitchment.common.entity.spirit.demon.AbstractGreaterDemon;
import com.bewitchment.common.entity.util.IPledgeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExtendedWorld
extends WorldSavedData {
    private static final String TAG = "bewitchment.world_data";
    public final List<NBTTagCompound> storedCauldrons = new ArrayList<NBTTagCompound>();
    public final List<NBTTagCompound> storedPoppetShelves = new ArrayList<NBTTagCompound>();
    public final Map<String, Set<UUID>> demonPledgedPlayers = new HashMap<String, Set<UUID>>();
    public final Map<BlockPos, Biome> STORED_OVERRIDE_BIOMES = new ConcurrentHashMap<BlockPos, Biome>();

    public ExtendedWorld(String name) {
        super(name);
    }

    public static ExtendedWorld get(World world) {
        ExtendedWorld data = (ExtendedWorld)world.func_175693_T().func_75742_a(ExtendedWorld.class, TAG);
        if (data == null) {
            data = new ExtendedWorld(TAG);
            world.func_175693_T().func_75745_a(TAG, (WorldSavedData)data);
        }
        return data;
    }

    public static void addOverriddenBiome(World world, BlockPos pos) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        extendedWorld.STORED_OVERRIDE_BIOMES.putIfAbsent(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), world.func_180494_b(pos));
        extendedWorld.func_76185_a();
    }

    public static void pledgePlayerToDemon(World world, EntityPlayer player, IPledgeable demon) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        HashSet<UUID> players = new HashSet<UUID>();
        if (extendedWorld.demonPledgedPlayers.containsKey(demon.getPledgeName())) {
            players.addAll((Collection)extendedWorld.demonPledgedPlayers.get(demon.getPledgeName()));
        }
        players.add(player.getPersistentID());
        extendedWorld.demonPledgedPlayers.put(demon.getPledgeName(), players);
        if (demon instanceof AbstractGreaterDemon && player instanceof EntityPlayerMP) {
            ((AbstractGreaterDemon)demon).bossInfo.func_186761_b((EntityPlayerMP)player);
        }
        extendedWorld.func_76185_a();
    }

    public static void depledgePlayerToDemon(World world, EntityPlayer player, IPledgeable demon) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        HashSet players = new HashSet();
        if (extendedWorld.demonPledgedPlayers.containsKey(demon.getPledgeName())) {
            players.addAll(extendedWorld.demonPledgedPlayers.get(demon.getPledgeName()));
        }
        players.remove(player.getPersistentID());
        extendedWorld.demonPledgedPlayers.put(demon.getPledgeName(), players);
        if (demon instanceof AbstractGreaterDemon && player instanceof EntityPlayerMP) {
            ((AbstractGreaterDemon)demon).bossInfo.func_186760_a((EntityPlayerMP)player);
        }
        extendedWorld.func_76185_a();
    }

    public static boolean playerPledgedToDemon(World world, EntityPlayer player, String demon) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        Set<UUID> players = extendedWorld.demonPledgedPlayers.get(demon);
        return players != null && players.contains(player.getPersistentID());
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int i;
        NBTTagList storedCauldrons = nbt.func_150295_c("storedCauldrons", 10);
        NBTTagList storedPoppetShelves = nbt.func_150295_c("storedPoppetShelves", 10);
        for (NBTBase tag2 : nbt.func_150295_c("biome_id", 10)) {
            this.STORED_OVERRIDE_BIOMES.put(BlockPos.func_177969_a((long)((NBTTagCompound)tag2).func_74763_f("pos")), Biome.func_150568_d((int)((NBTTagCompound)tag2).func_74762_e("biomeId")));
        }
        for (i = 0; i < storedCauldrons.func_74745_c(); ++i) {
            this.storedCauldrons.add(storedCauldrons.func_150305_b(i));
        }
        for (i = 0; i < storedPoppetShelves.func_74745_c(); ++i) {
            this.storedPoppetShelves.add(storedPoppetShelves.func_150305_b(i));
        }
        nbt.func_150295_c("demonPledges", 10).forEach(tag -> this.readPledge(this.demonPledgedPlayers, (NBTTagCompound)tag));
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList storedCauldrons = new NBTTagList();
        NBTTagList storedPoppetShelves = new NBTTagList();
        NBTTagList demonPledges = new NBTTagList();
        for (NBTTagCompound cauldron : this.storedCauldrons) {
            storedCauldrons.func_74742_a((NBTBase)cauldron);
        }
        for (NBTTagCompound poppet : this.storedPoppetShelves) {
            storedPoppetShelves.func_74742_a((NBTBase)poppet);
        }
        this.demonPledgedPlayers.entrySet().forEach(entry -> this.writePledge((Map.Entry<String, Set<UUID>>)entry, demonPledges));
        nbt.func_74782_a("storedCauldrons", (NBTBase)storedCauldrons);
        nbt.func_74782_a("storedPoppetShelves", (NBTBase)storedPoppetShelves);
        nbt.func_74782_a("demonPledges", (NBTBase)demonPledges);
        NBTTagList biomeOverrides = new NBTTagList();
        this.STORED_OVERRIDE_BIOMES.forEach((pos, biome) -> {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("pos", pos.func_177986_g());
            data.func_74768_a("biomeId", Biome.func_185362_a((Biome)biome));
            biomeOverrides.func_74742_a((NBTBase)data);
        });
        nbt.func_74782_a("biome_id", (NBTBase)biomeOverrides);
        return nbt;
    }

    private void writePledge(Map.Entry<String, Set<UUID>> entry, NBTTagList list) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("demon", entry.getKey());
        NBTTagList players = new NBTTagList();
        for (UUID uuid : entry.getValue()) {
            players.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        data.func_74782_a("players", (NBTBase)players);
        list.func_74742_a((NBTBase)data);
    }

    private void readPledge(Map<String, Set<UUID>> map, NBTTagCompound tag) {
        HashSet<UUID> players = new HashSet<UUID>();
        String demon = tag.func_74779_i("demon");
        for (NBTBase player : tag.func_150295_c("players", 8)) {
            players.add(UUID.fromString(((NBTTagString)player).func_150285_a_()));
        }
        map.put(demon, players);
    }

    public void syncToClient(EntityPlayerMP player) {
        Bewitchment.network.sendTo((IMessage)new SyncExtendedWorld(this.func_189551_b(new NBTTagCompound())), player);
    }
}

