/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api;

import com.bewitchment.Bewitchment;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.misc.Weakness;
import com.bewitchment.api.registry.AltarUpgrade;
import com.bewitchment.registry.ModObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class BewitchmentAPI {
    public static final Map<Predicate<EntityLivingBase>, Collection<ItemStack>> ATHAME_LOOT = new HashMap<Predicate<EntityLivingBase>, Collection<ItemStack>>();
    public static final Map<Predicate<BlockWorldState>, AltarUpgrade> ALTAR_UPGRADES = new HashMap<Predicate<BlockWorldState>, AltarUpgrade>();
    public static final List<EntityEntry> VALID_PETS = new ArrayList<EntityEntry>();
    public static EnumCreatureAttribute DEMON = EnumHelper.addCreatureAttribute((String)"DEMON");
    public static EnumCreatureAttribute SPIRIT = EnumHelper.addCreatureAttribute((String)"SPIRIT");
    public static EnumCreatureAttribute FAE = EnumHelper.addCreatureAttribute((String)"FAE");
    public static final Weakness COLD_IRON_WEAKNESS = Weakness.create(entity -> {
        EnumCreatureAttribute attribute = entity.func_70668_bt();
        String[] names = new String[]{"Hirschgeist", "Fairy", "Succubus", "Dullahan", "Pixie", "Incubus", "GaiaBaphomet", "Banshee", "Kikimora", "Dryad", "Satyress", "YukiOnna", "NineTails", "Spriggan", "Valkyrie", "Oni", "Deathword", "Mandragora", "Beholder", "Selkie", "Siren", "Dryad"};
        return attribute == DEMON || attribute == SPIRIT || attribute == FAE || Arrays.stream(names).anyMatch(name -> entity.getClass().getName().contains((CharSequence)name));
    }, new String[0]);
    public static final Weakness SILVER_WEAKNESS = Weakness.create(entity -> {
        String[] names = new String[]{"Dracula", "TurnedVillager", "Wendigo", "Dhampir", "Werecat", "Mummy", "BoneKnight", "Lich"};
        return Arrays.stream(names).anyMatch(name -> entity.getClass().getName().contains((CharSequence)name));
    }, new String[0]);
    public static BiomeDictionary.Type IMMUTABLE;
    private static BewitchmentAPI INSTANCE;

    public static boolean isWitch(EntityLivingBase entity) {
        return !BewitchmentAPI.isWitchHunter(entity) && (entity instanceof EntityWitch || entity instanceof EntityPlayer && Bewitchment.proxy.doesPlayerHaveAdvancement((EntityPlayer)entity, new ResourceLocation("bewitchment", "crafted_altar")));
    }

    public static boolean hasPets(EntityPlayer entity) {
        return ((ExtendedPlayer)entity.getCapability(ExtendedPlayer.CAPABILITY, null)).pets > 0;
    }

    public static boolean isVampire(EntityLivingBase entity) {
        return entity.getClass().getName().contains("Vampire");
    }

    public static boolean isWerewolf(EntityLivingBase entity) {
        return entity.getClass().getName().contains("Werewolf");
    }

    public static boolean isSpectre(EntityLivingBase entity) {
        return false;
    }

    public static boolean isSpirit(EntityLivingBase entity) {
        return entity.func_70668_bt() == SPIRIT;
    }

    public static boolean defeatedBoss(EntityPlayer entity) {
        return !((ExtendedPlayer)entity.getCapability(ExtendedPlayer.CAPABILITY, null)).uniqueDefeatedBosses.func_82582_d();
    }

    public static boolean isInfused(EntityPlayer entity) {
        return false;
    }

    public static boolean hasEffects(EntityPlayer entity) {
        for (PotionEffect potion : entity.func_70651_bq()) {
            if (potion.func_82720_e()) continue;
            return true;
        }
        return false;
    }

    public static boolean isWitchHunter(EntityLivingBase entity) {
        return false;
    }

    public static boolean hasBesmirchedGear(EntityLivingBase entity) {
        List armor = (List)entity.func_184193_aE();
        ArrayList<Item> armorItem = new ArrayList<Item>();
        for (ItemStack is : armor) {
            armorItem.add(is.func_77973_b());
        }
        return (armorItem.contains(ModObjects.besmirched_cowl) || armorItem.contains(ModObjects.besmirched_hat)) && armorItem.contains(ModObjects.besmirched_robes) && armorItem.contains(ModObjects.besmirched_pants);
    }

    public static boolean hasColdIronGear(EntityLivingBase entity) {
        List armor = (List)entity.func_184193_aE();
        ArrayList<Item> armorItem = new ArrayList<Item>();
        for (ItemStack is : armor) {
            armorItem.add(is.func_77973_b());
        }
        return armorItem.contains(ModObjects.cold_iron_helmet) && armorItem.contains(ModObjects.cold_iron_chestplate) && armorItem.contains(ModObjects.cold_iron_leggings) && armorItem.contains(ModObjects.cold_iron_boots);
    }

    public static boolean hasGreenWitchGear(EntityLivingBase entity) {
        List armor = (List)entity.func_184193_aE();
        ArrayList<Item> armorItem = new ArrayList<Item>();
        for (ItemStack is : armor) {
            armorItem.add(is.func_77973_b());
        }
        return (armorItem.contains(ModObjects.green_witch_cowl) || armorItem.contains(ModObjects.green_witch_hat)) && armorItem.contains(ModObjects.green_witch_robes) && armorItem.contains(ModObjects.green_witch_pants);
    }

    public static boolean hasAlchemistGear(EntityLivingBase entity) {
        List armor = (List)entity.func_184193_aE();
        ArrayList<Item> armorItem = new ArrayList<Item>();
        for (ItemStack is : armor) {
            armorItem.add(is.func_77973_b());
        }
        return (armorItem.contains(ModObjects.alchemist_cowl) || armorItem.contains(ModObjects.alchemist_hat)) && armorItem.contains(ModObjects.alchemist_robes) && armorItem.contains(ModObjects.alchemist_pants);
    }

    public static boolean hasWitchesGear(EntityLivingBase entity) {
        List armor = (List)entity.func_184193_aE();
        ArrayList<Item> armorItem = new ArrayList<Item>();
        for (ItemStack is : armor) {
            armorItem.add(is.func_77973_b());
        }
        return (armorItem.contains(ModObjects.witches_cowl) || armorItem.contains(ModObjects.witches_hat)) && armorItem.contains(ModObjects.witches_robes) && armorItem.contains(ModObjects.witches_pants);
    }

    public static final void setupAPI(BewitchmentAPI api) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Bewitchment API already initialized");
        }
        INSTANCE = api;
    }
}

