/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.structures.plants.StructureReeds;
import paulevs.betternether.world.BNWorldGenerator;

public class NetherBiomeJungle
extends NetherBiome {
    public NetherBiomeJungle(String name) {
        super(name);
    }

    @Override
    public void genFloorObjects(World world, BlockPos pos, Random random) {
        Block ground = world.func_180495_p(pos).func_177230_c();
        if (ground instanceof BlockNetherrack || ground == Blocks.field_150425_aM) {
            boolean reeds = false;
            if (BlocksRegister.BLOCK_NETHER_REED != Blocks.field_150350_a && random.nextInt(4) == 0) {
                reeds = StructureReeds.generate(world, pos, random);
            }
            if (!reeds) {
                if (BNWorldGenerator.hasEyeGen && random.nextInt(8) == 0) {
                    BNWorldGenerator.stalagnateGen.generate(world, pos, random);
                } else if (BNWorldGenerator.hasMagmaFlowerGen && pos.func_177956_o() < 37 && pos.func_177956_o() > 23 && random.nextInt(32) == 0) {
                    BNWorldGenerator.magmaFlowerGen.generate(world, pos, random);
                } else if (BNWorldGenerator.hasEggPlantGen && random.nextInt(16) == 0) {
                    BNWorldGenerator.eggPlantGen.generate(world, pos, random);
                } else if (BlocksRegister.BLOCK_NETHER_GRASS != Blocks.field_150350_a && random.nextInt(3) != 0) {
                    world.func_175656_a(pos.func_177984_a(), BlocksRegister.BLOCK_NETHER_GRASS.func_176223_P());
                }
            }
        }
    }

    @Override
    public void genWallObjects(World world, BlockPos origin, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && BNWorldGenerator.hasLucisGen && random.nextInt(4) == 0 && world.func_180495_p(origin).func_177230_c() == Blocks.field_150424_aL) {
            BNWorldGenerator.lucisGen.generate(world, pos, random);
        }
    }

    @Override
    public void genCeilObjects(World world, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && BNWorldGenerator.hasEyeGen && random.nextInt(8) == 0 && random.nextDouble() * 4.0 + 0.5 < this.getFeatureNoise(pos)) {
            BNWorldGenerator.eyeGen.generate(world, pos.func_177977_b(), random);
        }
    }

    @Override
    public void genSurfColumn(World world, BlockPos pos, Random random) {
        if (random.nextFloat() <= this.plantDensity && world.func_180495_p(pos).func_177230_c() == Blocks.field_150424_aL) {
            if (BlocksRegister.BLOCK_NETHERRACK_MOSS != Blocks.field_150350_a) {
                switch (random.nextInt(3)) {
                    case 0: {
                        world.func_175656_a(pos, Blocks.field_150425_aM.func_176223_P());
                        break;
                    }
                    case 1: {
                        world.func_175656_a(pos, BlocksRegister.BLOCK_NETHERRACK_MOSS.func_176223_P());
                    }
                }
            } else if (random.nextInt(3) == 0) {
                world.func_175656_a(pos, Blocks.field_150425_aM.func_176223_P());
            }
        }
    }
}

