/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cave;

import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import net.minecraftforge.common.config.Config;

public class ConfigCubicCave {
    @Config.Name(value="Type 1 Cave Minimum Altitude")
    @Config.Comment(value={"The minimum y-coordinate at which type 1 caves can generate.\nDefault: 1"})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int caveBottom = 1;
    @Config.Name(value="Type 1 Cave Maximum Altitude")
    @Config.Comment(value={"The maximum y-coordinate at which type 1 caves can generate.\nDefault: 80"})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int caveTop = 80;
    @Config.Name(value="Type 1 Cave Surface Cutoff Depth")
    @Config.Comment(value={"The depth from a given point on the surface at which type 1 caves start to close off.\n    Will use the Max Cave Altitude instead of surface height if it is lower.\n    Will use the Max Cave Altitude no matter what if Override Surface Detection is enabled.\nDefault: 15 (recommended)"})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int caveSurfaceCutoff = 15;
    @Config.Name(value="Compression - Vertical")
    @Config.Comment(value={"Stretches caves vertically. Lower value = taller caves with steeper drops.\nDefault: 5.0 (recommended)"})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float yCompression = 5.0f;
    @Config.Name(value="Compression - Horizontal")
    @Config.Comment(value={"Stretches caves horizontally. Lower value = wider caves.\nDefault: 1.6 (recommended)"})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float xzCompression = 1.6f;
    @Config.Name(value="Type 1 Cave Priority")
    @Config.Comment(value={"Determines how frequently Type 1 Caves spawn. 0 = will not spawn at all.\nDefault: 10"})
    @Config.RangeInt(min=0, max=10)
    @Config.RequiresWorldRestart
    public int cavePriority = 10;
    @Config.Ignore
    @Config.Name(value="Advanced Settings")
    @Config.Comment(value={"Don't mess with these if you don't know what you're doing."})
    public Advanced advancedSettings = new Advanced();

    public class Advanced {
        @Config.Name(value="Noise Threshold")
        @Config.Comment(value={"Noise threshold for determining which blocks get mined out as part of cave generation\n    Blocks with generated noise values greater than this threshold will be dug out.\nDefault: 0.95"})
        @Config.RangeDouble(min=-1.0, max=1.0)
        @Config.RequiresWorldRestart
        public float noiseThreshold = 0.95f;
        @Config.Name(value="Fractal Octaves")
        @Config.Comment(value={"The number of octaves used for ridged multi-fractal noise generation.\nDefault: 1"})
        @Config.RequiresWorldRestart
        public int fractalOctaves = 1;
        @Config.Name(value="Fractal Gain")
        @Config.Comment(value={"The gain for successive octaves of ridged multi-fractal noise generation.\nDefault: 0.3"})
        @Config.RequiresWorldRestart
        public float fractalGain = 0.3f;
        @Config.Name(value="Fractal Frequency")
        @Config.Comment(value={"The frequency for ridged multi-fractal noise generation.\n    This determines how spread out or tightly knit cave systems are.\nDefault: 0.03"})
        @Config.RequiresWorldRestart
        public float fractalFrequency = 0.03f;
        @Config.Name(value="Number of Generators")
        @Config.Comment(value={"The number of noise generation functions used.\n    The intersection of these functions is used to calculate a single noise value.\n    Increasing this may decrease performance.\nDefault: 2"})
        @Config.RequiresWorldRestart
        public int numGenerators = 2;
        @Config.Name(value="Enable y-adjustment")
        @Config.Comment(value={"Enable y-adjustment, giving players more headroom in caves.\nDefault: true"})
        public boolean yAdjust = true;
        @Config.Name(value="y-adjustment Variable 1")
        @Config.Comment(value={"Adjustment factor affecting the block immediately above a given block.\n    Higher value will tend to increase the headroom in caves.\nDefault: 0.9"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float yAdjustF1 = 0.9f;
        @Config.Name(value="y-adjustment Variable 2")
        @Config.Comment(value={"Adjustment factor affecting the block two blocks above a given block.\n    Higher value will tend to increase the headroom in caves.\nDefault: 0.9"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float yAdjustF2 = 0.9f;
        @Config.Name(value="Noise Type")
        @Config.Comment(value={"Type of noise to use for this cave. \nDefault: CubicFractal"})
        public FastNoise.NoiseType noiseType = FastNoise.NoiseType.CubicFractal;
    }
}

