/*
 * Decompiled with CFR 0.152.
 */
package kiba.bhc.gui.container;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import kiba.bhc.handler.ConfigHandler;
import kiba.bhc.items.BaseHeartCanister;
import kiba.bhc.util.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerPendant
extends Container {
    public static final String HEART_AMOUNT = "heart_amount";
    private final ItemStackHandler itemHandler;
    private final ItemStack pendant;

    public ContainerPendant(@Nonnull ItemStack pendant, @Nonnull InventoryPlayer playerInventory, @Nonnull EnumHand hand) {
        Preconditions.checkNotNull((Object)pendant, (Object)"pendant cannot be null");
        Preconditions.checkNotNull((Object)playerInventory, (Object)"playerInventory cannot be null");
        Preconditions.checkNotNull((Object)hand, (Object)"hand cannot be null");
        this.itemHandler = InventoryUtil.createVirtualInventory(4, pendant);
        this.pendant = pendant;
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemHandler, 0, 80, 9));
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemHandler, 1, 53, 33));
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemHandler, 2, 107, 33));
        this.func_75146_a((Slot)new SlotPendant((IItemHandler)this.itemHandler, 3, 80, 57));
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j1 + l * 9 + 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 142));
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        InventoryUtil.serializeInventory(this.itemHandler, this.pendant);
        NBTTagCompound nbt = this.pendant.func_77978_p();
        int[] hearts = new int[this.itemHandler.getSlots()];
        for (int i = 0; i < hearts.length; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            hearts[i] = stack.func_190916_E() * 2;
        }
        nbt.func_74783_a(HEART_AMOUNT, hearts);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index < this.itemHandler.getSlots() ? !this.func_75135_a(slotStack, this.itemHandler.getSlots(), this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.itemHandler.getSlots(), false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    private static class SlotPendant
    extends SlotItemHandler {
        public SlotPendant(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return super.func_75214_a(stack) && stack.func_77973_b() instanceof BaseHeartCanister && ((BaseHeartCanister)stack.func_77973_b()).type.ordinal() == this.getSlotIndex();
        }

        public int func_75219_a() {
            return ConfigHandler.heartStackSize;
        }
    }
}

