/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import hellfirepvp.astralsorcery.common.structure.array.StructureBlockArray;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.world.WorldGenAttributeCommon;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public abstract class WorldGenAttributeStructure
extends WorldGenAttributeCommon {
    private static boolean generatingStructure = false;
    protected final StructureGenBuffer.StructureType type;
    protected float idealDistance = 256.0f;
    private final WorldGenAttributeCommon.StructureQuery query;

    public WorldGenAttributeStructure(int attributeVersion, String entry, WorldGenAttributeCommon.StructureQuery query, StructureGenBuffer.StructureType type, boolean ignoreBiomeSpecifications, BiomeDictionary.Type ... types) {
        super(attributeVersion, entry, ignoreBiomeSpecifications, types);
        this.query = query;
        this.type = type;
    }

    public WorldGenAttributeStructure(int attributeVersion, int defaultChance, String entry, WorldGenAttributeCommon.StructureQuery query, StructureGenBuffer.StructureType type, boolean ignoreBiomeSpecifications, BiomeDictionary.Type ... types) {
        super(attributeVersion, defaultChance, entry, ignoreBiomeSpecifications, types);
        this.query = query;
        this.type = type;
    }

    public StructureGenBuffer.StructureType getStructureType() {
        return this.type;
    }

    public float getIdealDistance() {
        return this.idealDistance;
    }

    public StructureBlockArray getStructureTemplate() {
        return this.query.getStructure();
    }

    protected StructureGenBuffer getBuffer(World world) {
        return (StructureGenBuffer)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.STRUCTURE_GEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (generatingStructure) {
            return;
        }
        generatingStructure = true;
        try {
            super.generate(random, chunkX, chunkZ, world);
        }
        finally {
            generatingStructure = false;
        }
    }

    protected void generateAsSubmergedStructure(World world, BlockPos center) {
        HashMap prevStates = Maps.newHashMap();
        StructureBlockArray array = this.query.getStructure();
        for (BlockPos offset : array.getPattern().keySet()) {
            BlockPos at = offset.func_177971_a((Vec3i)center);
            prevStates.put(at, world.func_180495_p(at));
        }
        Map<BlockPos, IBlockState> placedStates = array.placeInWorld(world, center);
        LinkedList positions = Lists.newLinkedList(prevStates.keySet());
        MiscUtils.mergeList(placedStates.keySet(), positions);
        IBlockState airState = Blocks.field_150350_a.func_176223_P();
        for (BlockPos pos : positions) {
            IBlockState prev = prevStates.getOrDefault(pos, airState);
            IBlockState now = placedStates.getOrDefault(pos, airState);
            if (!MiscUtils.isFluidBlock(prev)) continue;
            BlockPos it = pos;
            while (now.func_177230_c().isAir(now, (IBlockAccess)world, it) && world.func_175656_a(it, prev) && placedStates.containsKey(it = it.func_177977_b())) {
                now = placedStates.getOrDefault(it, airState);
            }
        }
    }

    @Override
    protected void loadAdditionalConfigEntries(Configuration cfg) {
        super.loadAdditionalConfigEntries(cfg);
        this.idealDistance = cfg.getFloat("idealDistance", this.cfgEntry.getConfigurationSection(), this.idealDistance, 1.0f, 16384.0f, "Sets the 'ideal' distance between 2 structures of the same type. If the distance is lower, it's unlikely that the same type of structure will spawn,if it's higher it's more likely that this type of structure will spawn. Only has influence if the config option 'respectIdealStructureDistances' is enabled.");
    }
}

