/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.log;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.util.Provider;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class LogUtil {
    private static boolean loggingEnabled = false;
    private static Set<LogCategory> loggedCategories = new HashSet<LogCategory>();
    private static final String PREFIX = "[DEBUG-%s]: %s";

    public static void info(LogCategory category, Provider<String> msgProvider) {
        if (loggingEnabled && loggedCategories.contains((Object)category)) {
            AstralSorcery.log.info(String.format(PREFIX, category.name(), msgProvider.provide()));
        }
    }

    public static void warn(LogCategory category, Provider<String> msgProvider) {
        if (loggingEnabled && loggedCategories.contains((Object)category)) {
            AstralSorcery.log.warn(String.format(PREFIX, category.name(), msgProvider.provide()));
        }
    }

    public static class CfgEntry
    extends ConfigEntry {
        public CfgEntry() {
            super(ConfigEntry.Section.GENERAL, "debug_logging");
        }

        @Override
        public void loadFromConfig(Configuration cfg) {
            loggedCategories.clear();
            for (LogCategory cat : LogCategory.values()) {
                boolean enabled = cfg.getBoolean(cat.name(), this.getConfigurationSection(), false, "Set to true to enable this logging category. Only do this if you have to debug this section of code! May spam your log HEAVILY!");
                if (!enabled) continue;
                loggedCategories.add(cat);
            }
            loggingEnabled = !loggedCategories.isEmpty();
        }
    }
}

