/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.effect;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightning;
import hellfirepvp.astralsorcery.common.base.ShootingStarHandler;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShootingStarExplosion {
    public static void play(World world, double x, double y, double z, boolean extinguished, long seed) {
        ShootingStarExplosion.play(world, new Vector3(x, y, z), extinguished, seed);
    }

    public static void play(World world, Vector3 pos, boolean extinguished, long seed) {
        if (!extinguished && ShootingStarHandler.StarConfigEntry.doExplosion) {
            boolean doDamage = world.func_82736_K().func_82766_b("mobGriefing");
            world.func_72885_a(null, pos.getX(), pos.getY(), pos.getZ(), 4.5f, false, doDamage);
        }
        PktParticleEvent ev = extinguished ? new PktParticleEvent(PktParticleEvent.ParticleEventType.SH_STAR_EX, pos) : new PktParticleEvent(PktParticleEvent.ParticleEventType.SH_STAR, pos);
        ev.setAdditionalDataLong(seed);
        PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)pos.toBlockPos(), 128.0));
    }

    @SideOnly(value=Side.CLIENT)
    public static void playEffects(PktParticleEvent event) {
        ShootingStarExplosion.playParticles(event.getVec(), false, event.getAdditionalDataLong());
    }

    @SideOnly(value=Side.CLIENT)
    public static void playExEffects(PktParticleEvent event) {
        ShootingStarExplosion.playParticles(event.getVec(), true, event.getAdditionalDataLong());
    }

    @SideOnly(value=Side.CLIENT)
    private static void playParticles(Vector3 pos, boolean extinguished, long seed) {
        Random r = new Random(seed);
        Color c = Color.getHSBColor(r.nextFloat() * 360.0f, 1.0f, 1.0f);
        if (!extinguished) {
            block5: for (int i = 0; i < 14; ++i) {
                Vector3 randTo = new Vector3(r.nextFloat() * 8.0f * (float)(r.nextBoolean() ? 1 : -1), r.nextFloat() * 5.0f, r.nextFloat() * 8.0f * (float)(r.nextBoolean() ? 1 : -1));
                EffectLightning lightning = EffectHandler.getInstance().lightning(pos, pos.clone().add(randTo));
                lightning.setBuildSpeed(0.12f);
                switch (r.nextInt(3)) {
                    case 0: {
                        lightning.setOverlayColor(c);
                        continue block5;
                    }
                    case 1: {
                        lightning.setOverlayColor(c.brighter().brighter());
                        continue block5;
                    }
                    case 2: {
                        lightning.setOverlayColor(Color.WHITE);
                        continue block5;
                    }
                }
            }
            Vector3 perp = Vector3.RotAxis.Y_AXIS.clone().perpendicular().normalize();
            for (double i = 0.0; i <= 360.0; i += 0.9) {
                Vector3 dir = perp.clone().rotate(Math.toRadians(i), Vector3.RotAxis.Y_AXIS).normalize();
                Vector3 p = dir.clone().multiply(3.0 + r.nextDouble() * 4.0).add(pos);
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(p.getX(), p.getY(), p.getZ());
                dir.multiply(0.06);
                particle.motion(dir.getX() + r.nextDouble() * 0.005, dir.getY() + 0.01 + r.nextDouble() * 0.01, dir.getZ() + r.nextDouble() * 0.005).setColor(Color.BLUE).scale(1.5f).gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setMaxAge(55 + r.nextInt(20));
                particle.setAlphaMultiplier(0.4f).setColor(r.nextBoolean() ? Color.WHITE : c);
            }
        }
        for (int i = 0; i < 70; ++i) {
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(pos);
            particle.offset((double)r.nextFloat() * 0.5 * (double)(r.nextBoolean() ? 1 : -1), (double)r.nextFloat() * 0.5 * (double)(r.nextBoolean() ? 1 : -1), (double)r.nextFloat() * 0.5 * (double)(r.nextBoolean() ? 1 : -1)).motion((r.nextBoolean() ? 0.2 : 1.0) * (double)r.nextFloat() * 0.07 * (double)(r.nextBoolean() ? 1 : -1), (r.nextBoolean() ? 0.2 : 1.0) * (double)r.nextFloat() * 0.07 * (double)(r.nextBoolean() ? 1 : -1), (r.nextBoolean() ? 0.2 : 1.0) * (double)r.nextFloat() * 0.07 * (double)(r.nextBoolean() ? 1 : -1)).scale(0.8f + r.nextFloat() * 0.4f).gravity(0.004).setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setMaxAge(80 + r.nextInt(20));
            if (extinguished || r.nextInt(3) != 0) continue;
            particle.setColor(c);
        }
    }
}

