/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.tool.ItemSkyResonator;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ResonatorLiquidRecipe
extends TraitRecipe {
    public ResonatorLiquidRecipe() {
        super(ShapedRecipe.Builder.newShapedRecipe("internal/altar/resonator/liquid", ItemSkyResonator.setCurrentUpgradeUnsafe(ItemSkyResonator.setUpgradeUnlocked(ItemSkyResonator.setEnhanced(new ItemStack((Item)ItemsAS.skyResonator)), ItemSkyResonator.ResonatorUpgrade.FLUID_FIELDS), ItemSkyResonator.ResonatorUpgrade.FLUID_FIELDS)).addPart(ItemsAS.skyResonator, ShapedRecipeSlot.CENTER).addPart(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), ShapedRecipeSlot.LOWER_CENTER).addPart(ItemUsableDust.DustType.ILLUMINATION.asStack(), ShapedRecipeSlot.UPPER_CENTER).addPart(OreDictAlias.ITEM_STARMETAL_DUST, ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT).unregisteredAccessibleShapedRecipe());
        this.setCstItem(ItemCraftingComponent.MetaType.STARDUST.asStack(), ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT);
        this.setInnerTraitItem(ItemUsableDust.DustType.ILLUMINATION.asStack(), TraitRecipe.TraitRecipeSlot.UPPER_CENTER);
        this.setCstItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_LEFT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_RIGHT);
        this.addOuterTraitItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack());
        this.addOuterTraitItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack());
        this.addOuterTraitItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack());
        this.setRequiredConstellation(Constellations.octans);
    }

    @Override
    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        ItemStack center = invHandler.getStackInSlot(ShapedRecipeSlot.CENTER.getSlotID());
        if (center.func_190926_b() || !(center.func_77973_b() instanceof ItemSkyResonator)) {
            return false;
        }
        List<ItemSkyResonator.ResonatorUpgrade> out = ItemSkyResonator.getUpgrades(center);
        return !out.contains((Object)ItemSkyResonator.ResonatorUpgrade.FLUID_FIELDS) && super.matches(altar, invHandler, ignoreStarlightRequirement);
    }

    @Override
    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        ItemStack reso = new ItemStack((Item)ItemsAS.skyResonator);
        ItemStack center = altar.getInventoryHandler().getStackInSlot(ShapedRecipeSlot.CENTER.getSlotID());
        if (!center.func_190926_b() && center.func_77973_b() instanceof ItemSkyResonator) {
            reso = ItemUtils.copyStackWithSize(center, center.func_190916_E());
        }
        ItemSkyResonator.setEnhanced(reso);
        ItemSkyResonator.setUpgradeUnlocked(reso, ItemSkyResonator.ResonatorUpgrade.FLUID_FIELDS);
        return reso;
    }
}

