/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IPlayerTickPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;

public class KeyStoneEnrichment
extends KeyPerk
implements IPlayerTickPerk {
    private static final BlockStateCheck stoneCheck = new CleanStoneCheck();
    private int enrichmentRadius = 3;
    private int chanceToEnrich = 70;

    public KeyStoneEnrichment(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                KeyStoneEnrichment.this.enrichmentRadius = cfg.getInt("Effect_Radius", this.getConfigurationSection(), KeyStoneEnrichment.this.enrichmentRadius, 1, 35, "Defines the radius where a random position to generate a ore at is searched");
                KeyStoneEnrichment.this.chanceToEnrich = cfg.getInt("Chance_To_CreateOre", this.getConfigurationSection(), KeyStoneEnrichment.this.chanceToEnrich, 2, 4000000, "Sets the chance (Random.nextInt(chance) == 0) to try to see if a random stone next to the player should get turned into an ore; the lower the more likely");
            }
        });
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.enrichmentRadius = MathHelper.func_76143_f((double)((double)this.enrichmentRadius * multiplier));
        this.chanceToEnrich = MathHelper.func_76143_f((double)((double)this.chanceToEnrich * multiplier));
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER) {
            PlayerProgress prog = ResearchManager.getProgress(player, side);
            float modChance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.perkeffect", this.chanceToEnrich);
            if (rand.nextInt(Math.round(Math.max(modChance, 1.0f))) == 0) {
                IBlockState state;
                ItemStack blockStack;
                float enrRad = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.perkeffect", this.enrichmentRadius);
                Vector3 vec = Vector3.atEntityCenter((Entity)player).add(rand.nextFloat() * enrRad * 2.0f - enrRad, rand.nextFloat() * enrRad * 2.0f - enrRad, rand.nextFloat() * enrRad * 2.0f - enrRad);
                BlockPos pos = vec.toBlockPos();
                if (stoneCheck.isStateValid(player.func_130014_f_().func_180495_p(pos)) && !(blockStack = OreTypes.AEVITAS_ORE_PERK.getRandomOre(rand)).func_190926_b() && (state = ItemUtils.createBlockState(blockStack)) != null) {
                    player.func_130014_f_().func_175656_a(pos, state);
                }
            }
        }
    }

    private static class CleanStoneCheck
    implements BlockStateCheck {
        private CleanStoneCheck() {
        }

        @Override
        public boolean isStateValid(IBlockState state) {
            return state.func_177230_c() == Blocks.field_150348_b && ((BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a)).equals((Object)BlockStone.EnumType.STONE);
        }
    }
}

