/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GemAttributeModifier
extends PerkAttributeModifier {
    private final UUID uuid;
    private PerkAttributeModifier actualModifier = null;
    private static Map<UUID, Map<PerkConverter, Table<String, PerkAttributeModifier.Mode, PerkAttributeModifier>>> gemConverterCache = Maps.newHashMap();

    public GemAttributeModifier(UUID uniqueId, String type, PerkAttributeModifier.Mode mode, float value) {
        super(type, mode, value);
        this.uuid = uniqueId;
    }

    @Override
    protected void initModifier() {
        super.initModifier();
        this.setAbsolute();
    }

    @Override
    @Nonnull
    public PerkAttributeModifier convertModifier(String attributeType, PerkAttributeModifier.Mode mode, float value) {
        PerkAttributeModifier mod = super.convertModifier(attributeType, mode, value);
        GemAttributeModifier gemMod = new GemAttributeModifier(this.getUniqueId(), mod.getAttributeType(), mod.getMode(), mod.getFlatValue());
        gemMod.setId(mod.getId());
        return gemMod;
    }

    @Override
    @Nullable
    protected PerkAttributeModifier getCachedAttributeModifier(PerkConverter converter, String attributeType, PerkAttributeModifier.Mode mode) {
        Map modifierCache = gemConverterCache.computeIfAbsent(this.getUniqueId(), u -> new HashMap());
        Table cachedModifiers = modifierCache.computeIfAbsent(converter, c -> HashBasedTable.create());
        return (PerkAttributeModifier)cachedModifiers.get((Object)attributeType, (Object)mode);
    }

    @Override
    protected void addModifierToCache(PerkConverter converter, String attributeType, PerkAttributeModifier.Mode mode, PerkAttributeModifier modifier) {
        Map modifierCache = gemConverterCache.computeIfAbsent(this.getUniqueId(), u -> new HashMap());
        Table cachedModifiers = modifierCache.computeIfAbsent(converter, c -> HashBasedTable.create());
        cachedModifiers.put((Object)attributeType, (Object)mode, (Object)modifier);
    }

    private boolean resolveModifier() {
        if (this.actualModifier != null) {
            return true;
        }
        PerkAttributeType type = AttributeTypeRegistry.getType(this.attributeType);
        if (type != null) {
            this.actualModifier = type.createModifier(this.value, this.mode);
            this.actualModifier.setAbsolute();
            return true;
        }
        return false;
    }

    @Override
    public float getValue(EntityPlayer player, PlayerProgress progress) {
        if (!this.resolveModifier()) {
            return super.getValue(player, progress);
        }
        return this.actualModifier.getValue(player, progress);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getValueForDisplay(EntityPlayer player, PlayerProgress progress) {
        if (!this.resolveModifier()) {
            return super.getValueForDisplay(player, progress);
        }
        return this.actualModifier.getValueForDisplay(player, progress);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAttributeDisplayFormat() {
        if (!this.resolveModifier()) {
            return super.getAttributeDisplayFormat();
        }
        return this.actualModifier.getAttributeDisplayFormat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUnlocalizedAttributeName() {
        if (!this.resolveModifier()) {
            return super.getUnlocalizedAttributeName();
        }
        return this.actualModifier.getUnlocalizedAttributeName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasDisplayString() {
        if (!this.resolveModifier()) {
            return super.hasDisplayString();
        }
        return this.actualModifier.hasDisplayString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedAttributeValue() {
        if (!this.resolveModifier()) {
            return super.getLocalizedAttributeValue();
        }
        return this.actualModifier.getLocalizedAttributeValue();
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedDisplayString() {
        if (!this.resolveModifier()) {
            return super.getLocalizedDisplayString();
        }
        return this.actualModifier.getLocalizedDisplayString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedModifierName() {
        if (!this.resolveModifier()) {
            return super.getLocalizedModifierName();
        }
        return this.actualModifier.getLocalizedModifierName();
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("id", this.getUniqueId());
        tag.func_74778_a("type", this.getAttributeType());
        tag.func_74768_a("mode", this.getMode().getVanillaAttributeOperation());
        tag.func_74776_a("baseValue", this.value);
        tag.func_74772_a("mId", this.getId());
        return tag;
    }

    public static GemAttributeModifier deserialize(NBTTagCompound tag) {
        UUID id = tag.func_186857_a("id");
        String type = tag.func_74779_i("type");
        PerkAttributeModifier.Mode mode = PerkAttributeModifier.Mode.fromVanillaAttributeOperation(tag.func_74762_e("mode"));
        float val = tag.func_74760_g("baseValue");
        long mId = tag.func_74763_f("mId");
        GemAttributeModifier mod = new GemAttributeModifier(id, type, mode, val);
        mod.setId(mId);
        return mod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GemAttributeModifier that = (GemAttributeModifier)o;
        return this.uuid.equals(that.uuid);
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }
}

