/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileGemCrystals;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockGemCrystals
extends BlockContainer
implements BlockCustomName,
BlockVariants {
    public static final PropertyEnum<GrowthStageType> STAGE = PropertyEnum.func_177709_a((String)"stage", GrowthStageType.class);
    private static final AxisAlignedBB boxStage0 = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.375, 0.75);
    private static final AxisAlignedBB boxStage1 = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB boxStage2Night = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB boxStage2Sky = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5625, 0.75);
    private static final AxisAlignedBB boxStage2Day = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5625, 0.75);

    public BlockGemCrystals() {
        super(Material.field_151576_e, MapColor.field_151677_p);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149752_b(20.0f);
        this.func_149715_a(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(STAGE, (Comparable)((Object)GrowthStageType.STAGE_0)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (GrowthStageType stageType : GrowthStageType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, stageType.ordinal()));
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        BlockPos down;
        boolean replaceable = super.func_176196_c(worldIn, pos);
        if (replaceable && !worldIn.isSideSolid(down = pos.func_177977_b(), EnumFacing.UP)) {
            replaceable = false;
        }
        return replaceable;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((GrowthStageType)((Object)state.func_177229_b(STAGE))) {
            case STAGE_0: {
                return boxStage0;
            }
            case STAGE_1: {
                return boxStage1;
            }
            case STAGE_2_SKY: {
                return boxStage2Sky;
            }
            case STAGE_2_DAY: {
                return boxStage2Day;
            }
            case STAGE_2_NIGHT: {
                return boxStage2Night;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return super.getPickBlock(world.func_180495_p(pos), target, world, pos, player);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        state.func_177226_a(STAGE, (Comparable)((Object)GrowthStageType.values()[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)GrowthStageType.values().length)]));
    }

    public int func_176201_c(IBlockState state) {
        return ((GrowthStageType)((Object)state.func_177229_b(STAGE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(STAGE, (Comparable)((Object)GrowthStageType.values()[MathHelper.func_76125_a((int)meta, (int)0, (int)GrowthStageType.values().length)]));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack gem = ItemStack.field_190927_a;
        switch ((GrowthStageType)((Object)state.func_177229_b(STAGE))) {
            case STAGE_2_SKY: {
                gem = ItemPerkGem.GemType.SKY.asStack();
                break;
            }
            case STAGE_2_DAY: {
                gem = ItemPerkGem.GemType.DAY.asStack();
                break;
            }
            case STAGE_2_NIGHT: {
                gem = ItemPerkGem.GemType.NIGHT.asStack();
            }
        }
        if (!gem.func_190926_b()) {
            drops.add((Object)gem);
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos down = pos.func_177977_b();
        IBlockState downState = worldIn.func_180495_p(down);
        if (!downState.isSideSolid((IBlockAccess)worldIn, down, EnumFacing.UP)) {
            this.func_176226_b(worldIn, pos, state, 0);
            this.func_180663_b(worldIn, pos, state);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileGemCrystals te = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileGemCrystals.class, true);
        if (te != null && !worldIn.field_72995_K) {
            PktParticleEvent event = new PktParticleEvent(PktParticleEvent.ParticleEventType.GEM_CRYSTAL_BURST, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            event.setAdditionalDataLong(((GrowthStageType)((Object)state.func_177229_b(STAGE))).ordinal());
            PacketChannel.CHANNEL.sendToAllAround((IMessage)event, PacketChannel.pointFromPos(worldIn, (Vec3i)pos, 32.0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149716_u() {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileGemCrystals();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileGemCrystals();
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        GrowthStageType type = (GrowthStageType)((Object)this.func_176203_a(meta).func_177229_b(STAGE));
        return type.func_176610_l();
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.singleEnumPropertyStates(this.func_176223_P(), (IProperty)STAGE, (Comparable[])GrowthStageType.values());
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((GrowthStageType)((Object)state.func_177229_b(STAGE))).func_176610_l();
    }

    public static enum GrowthStageType implements IStringSerializable
    {
        STAGE_0(0, Color.WHITE),
        STAGE_1(1, Color.WHITE),
        STAGE_2_SKY(2, new Color(2449845)),
        STAGE_2_DAY(2, new Color(14699522)),
        STAGE_2_NIGHT(2, new Color(0x808080));

        private final int growthStage;
        private final Color displayColor;

        private GrowthStageType(int growthStage, Color displayColor) {
            this.growthStage = growthStage;
            this.displayColor = displayColor;
        }

        public Color getDisplayColor() {
            return this.displayColor;
        }

        public int getGrowthStage() {
            return this.growthStage;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

