/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.StorageNetworkBuffer;
import hellfirepvp.astralsorcery.common.tile.TileStorageCore;
import hellfirepvp.astralsorcery.common.tile.storage.StorageNetwork;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StorageNetworkHandler {
    private static Map<Integer, NetworkHelper> mappingHelpers = new HashMap<Integer, NetworkHelper>();

    public static NetworkHelper getHandler(World world) {
        return mappingHelpers.computeIfAbsent(world.field_73011_w.getDimension(), id -> new NetworkHelper(world));
    }

    public static void clearHandler(World world) {
        StorageNetworkHandler.clearHandler(world.field_73011_w.getDimension());
    }

    public static void clearHandler(int dimId) {
        mappingHelpers.remove(dimId);
    }

    public static class MappingChange {
    }

    public static class NetworkHelper {
        private StorageNetworkBuffer buffer;

        private NetworkHelper(World world) {
            this.buffer = (StorageNetworkBuffer)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.STORAGE_BUFFER);
        }

        @Nullable
        public StorageNetwork getNetwork(BlockPos networkMaster) {
            return this.buffer.getNetwork(networkMaster);
        }

        public void addCore(TileStorageCore core) {
        }

        public void removeCore(TileStorageCore core) {
        }
    }
}

