/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class BlockModelRenderHelper {
    private static BlockFluidRenderer bfr;

    private static BlockFluidRenderer getFluidRenderer() {
        if (bfr == null) {
            bfr = new BlockFluidRenderer((BlockColors)new BlockColorsOverride(Minecraft.func_71410_x().func_184125_al()));
        }
        return bfr;
    }

    public static void renderBlockModelWithColor(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder vb, int color) {
        try {
            EnumBlockRenderType type = state.func_185901_i();
            if (type == EnumBlockRenderType.INVISIBLE) {
                return;
            }
            state = state.func_185899_b(world, pos);
            switch (type) {
                case MODEL: {
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
                    state = state.func_177230_c().getExtendedState(state, world, pos);
                    BlockModelRenderHelper.renderModelFlat(world, model, state, pos, vb, true, MathHelper.func_180186_a((Vec3i)pos), color);
                    break;
                }
                case LIQUID: {
                    BlockColorsOverride.override = color;
                    BlockModelRenderHelper.getFluidRenderer().func_178270_a(world, state, pos, vb);
                    BlockColorsOverride.override = -1;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_180523_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (Block)state.func_177230_c(), (int)state.func_177230_c().func_176201_c(state));
            throw new ReportedException(crashreport);
        }
    }

    private static void renderModelFlat(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, long rand, int color) {
        BitSet bitset = new BitSet(3);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            List sidedQuads = modelIn.func_188616_a(stateIn, enumfacing, rand);
            if (sidedQuads.isEmpty() || checkSides && !stateIn.func_185894_c(worldIn, posIn, enumfacing)) continue;
            int i = stateIn.func_185889_a(worldIn, posIn.func_177972_a(enumfacing));
            BlockModelRenderHelper.renderQuadsFlat(worldIn, stateIn, posIn, i, false, buffer, sidedQuads, bitset, color);
        }
        List quads = modelIn.func_188616_a(stateIn, null, rand);
        if (!quads.isEmpty()) {
            BlockModelRenderHelper.renderQuadsFlat(worldIn, stateIn, posIn, -1, true, buffer, quads, bitset, color);
        }
    }

    private static void renderQuadsFlat(IBlockAccess blockAccessIn, IBlockState stateIn, BlockPos posIn, int brightnessIn, boolean ownBrightness, BufferBuilder buffer, List<BakedQuad> list, BitSet bitSet, int color) {
        Vec3d vec3d = stateIn.func_191059_e(blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            if (ownBrightness) {
                BlockModelRenderHelper.fillQuadBounds(stateIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = stateIn.func_185889_a(blockAccessIn, blockpos);
            }
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (EntityRenderer.field_78517_a) {
                color = TextureUtil.func_177054_c((int)color);
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                red *= diffuse;
                green *= diffuse;
                blue *= diffuse;
            }
            buffer.func_178978_a(red, green, blue, 4);
            buffer.func_178978_a(red, green, blue, 3);
            buffer.func_178978_a(red, green, blue, 2);
            buffer.func_178978_a(red, green, blue, 1);
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    private static void fillQuadBounds(IBlockState stateIn, int[] vertexData, EnumFacing face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[EnumFacing.WEST.func_176745_a()] = f;
            quadBounds[EnumFacing.EAST.func_176745_a()] = f3;
            quadBounds[EnumFacing.DOWN.func_176745_a()] = f1;
            quadBounds[EnumFacing.UP.func_176745_a()] = f4;
            quadBounds[EnumFacing.NORTH.func_176745_a()] = f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a()] = f5;
            int j = EnumFacing.values().length;
            quadBounds[EnumFacing.WEST.func_176745_a() + j] = 1.0f - f;
            quadBounds[EnumFacing.EAST.func_176745_a() + j] = 1.0f - f3;
            quadBounds[EnumFacing.DOWN.func_176745_a() + j] = 1.0f - f1;
            quadBounds[EnumFacing.UP.func_176745_a() + j] = 1.0f - f4;
            quadBounds[EnumFacing.NORTH.func_176745_a() + j] = 1.0f - f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        switch (face) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || stateIn.func_185917_h()) && f == f3);
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || stateIn.func_185917_h()) && f == f3);
            }
        }
    }

    private static class BlockColorsOverride
    extends BlockColors {
        private static int override = -1;
        private final BlockColors prev;

        public BlockColorsOverride(BlockColors prev) {
            this.prev = prev;
        }

        public int func_186724_a(IBlockState state, @Nullable IBlockAccess blockAccess, @Nullable BlockPos pos, int tintIndex) {
            if (override != -1) {
                return override;
            }
            return this.prev.func_186724_a(state, blockAccess, pos, tintIndex);
        }
    }
}

