/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.api.definitions.IBlockDefinition;
import appeng.util.Platform;
import appeng.worldgen.meteorite.Fallout;
import appeng.worldgen.meteorite.IMeteoriteWorld;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import net.minecraft.block.state.IBlockState;

public class FalloutCopy
extends Fallout {
    private static final double SPECIFIED_BLOCK_THRESHOLD = 0.9;
    private static final double AIR_BLOCK_THRESHOLD = 0.8;
    private static final double BLOCK_THRESHOLD_STEP = 0.1;
    private final IBlockState block;
    private final MeteoriteBlockPutter putter;

    public FalloutCopy(IMeteoriteWorld w, int x, int y, int z, MeteoriteBlockPutter putter, IBlockDefinition skyStoneDefinition) {
        super(putter, skyStoneDefinition);
        this.putter = putter;
        this.block = w.getBlockState(x, y, z);
    }

    @Override
    public void getRandomFall(IMeteoriteWorld w, int x, int y, int z) {
        double a = Math.random();
        if (a > 0.9) {
            this.putter.put(w, x, y, z, this.block, 3);
        } else {
            this.getOther(w, x, y, z, a);
        }
    }

    public void getOther(IMeteoriteWorld w, int x, int y, int z, double a) {
    }

    @Override
    public void getRandomInset(IMeteoriteWorld w, int x, int y, int z) {
        double a = Math.random();
        if (a > 0.9) {
            this.putter.put(w, x, y, z, this.block, 3);
        } else if (a > 0.8) {
            this.putter.put(w, x, y, z, Platform.AIR_BLOCK);
        } else {
            this.getOther(w, x, y, z, a - 0.1);
        }
    }
}

