/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.tiles;

import al132.alchemistry.ConfigHandler;
import al132.alchemistry.recipes.LiquifierRecipe;
import al132.alchemistry.recipes.ModRecipes;
import al132.alchemistry.tiles.TileBase;
import al132.alib.tiles.ALTileStackHandler;
import al132.alib.tiles.EnergyTileImpl;
import al132.alib.tiles.IEnergyTile;
import al132.alib.tiles.IFluidTile;
import al132.alib.tiles.IGuiTile;
import al132.alib.tiles.IItemTile;
import al132.alib.utils.extensions.IItemHandlerKt;
import al132.alib.utils.extensions.ItemStackKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0019H\u0096\u0001J\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\"J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\"H\u0016J\u0006\u0010(\u001a\u00020\"J\u0010\u0010)\u001a\u00020&2\u0006\u0010%\u001a\u00020&H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000bX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Lal132/alchemistry/tiles/TileLiquifier;", "Lal132/alchemistry/tiles/TileBase;", "Lal132/alib/tiles/IGuiTile;", "Lnet/minecraft/util/ITickable;", "Lal132/alib/tiles/IItemTile;", "Lal132/alib/tiles/IFluidTile;", "Lal132/alib/tiles/IEnergyTile;", "()V", "currentRecipe", "Lal132/alchemistry/recipes/LiquifierRecipe;", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "fluidTanks", "Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "getFluidTanks", "()Lnet/minecraftforge/fluids/capability/templates/FluidHandlerConcatenate;", "outputTank", "Lnet/minecraftforge/fluids/FluidTank;", "getOutputTank", "()Lnet/minecraftforge/fluids/FluidTank;", "progressTicks", "", "getProgressTicks", "()I", "setProgressTicks", "(I)V", "canProcess", "", "energyCapacity", "initInventoryInputCapability", "", "process", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "update", "updateRecipe", "writeToNBT", "alchemistry"})
public final class TileLiquifier
extends TileBase
implements IGuiTile,
ITickable,
IItemTile,
IFluidTile,
IEnergyTile {
    @NotNull
    private final FluidTank outputTank;
    private LiquifierRecipe currentRecipe;
    private int progressTicks;
    private final /* synthetic */ EnergyTileImpl $$delegate_0;

    @NotNull
    public final FluidTank getOutputTank() {
        return this.outputTank;
    }

    public final int getProgressTicks() {
        return this.progressTicks;
    }

    public final void setProgressTicks(int n) {
        this.progressTicks = n;
    }

    @Nullable
    public FluidHandlerConcatenate getFluidTanks() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{(IFluidHandler)this.outputTank});
    }

    public void initInventoryInputCapability() {
        this.setInput(new ALTileStackHandler(this, this.getInputSlots(), this){
            final /* synthetic */ TileLiquifier this$0;

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                boolean bl;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                    Iterable $receiver$iv = ModRecipes.INSTANCE.getLiquifierRecipes();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            LiquifierRecipe it = (LiquifierRecipe)element$iv;
                            if (!it.getInput().func_77969_a(stack)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    ItemStack itemStack = super.insertItem(slot, stack, simulate);
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"super.insertItem(slot, stack, simulate)");
                    return itemStack;
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                this.this$0.updateRecipe();
                this.this$0.markDirtyGUI();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRecipe() {
        ItemStack inputStack;
        block5: {
            Object v2;
            block4: {
                void $receiver$iv;
                block6: {
                    ItemStack itemStack = this.getInput().getStackInSlot(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.input.getStackInSlot(0)");
                    inputStack = itemStack;
                    if (inputStack.func_190926_b()) break block5;
                    if (this.currentRecipe == null) break block6;
                    LiquifierRecipe liquifierRecipe = this.currentRecipe;
                    if (liquifierRecipe == null) {
                        Intrinsics.throwNpe();
                    }
                    if (ItemStack.func_77989_b((ItemStack)liquifierRecipe.getInput(), (ItemStack)inputStack)) break block5;
                }
                Iterable iterable = ModRecipes.INSTANCE.getLiquifierRecipes();
                TileLiquifier tileLiquifier = this;
                for (Object element$iv : $receiver$iv) {
                    LiquifierRecipe it = (LiquifierRecipe)element$iv;
                    if (!ItemStackKt.areItemsEqual((ItemStack)it.getInput(), (ItemStack)inputStack)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            Object var9_7 = v2;
            tileLiquifier.currentRecipe = var9_7;
        }
        if (inputStack.func_190926_b()) {
            this.currentRecipe = null;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!IItemHandlerKt.get((IItemHandler)((IItemHandler)this.getInput()), (int)0).func_190926_b() && this.canProcess()) {
                this.process();
            }
            this.markDirtyGUIEvery(5);
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        NBTTagCompound outputTankNBT = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankNBT);
        compound.func_74782_a("OutputTankNBT", (NBTBase)outputTankNBT);
        compound.func_74768_a("ProgressTicks", this.progressTicks);
        return compound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.outputTank.readFromNBT(compound.func_74775_l("OutputTankNBT"));
        this.progressTicks = compound.func_74762_e("ProgressTicks");
        this.updateRecipe();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canProcess() {
        if (this.currentRecipe == null) return false;
        LiquifierRecipe liquifierRecipe = this.currentRecipe;
        if (liquifierRecipe == null) {
            Intrinsics.throwNpe();
        }
        FluidStack recipeOutput = liquifierRecipe.getOutput();
        if (this.outputTank.getCapacity() < this.outputTank.getFluidAmount() + recipeOutput.amount) return false;
        int n = this.getEnergyStorage().getEnergyStored();
        Integer n2 = ConfigHandler.INSTANCE.getLiquifierEnergyPerTick();
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        if (n < n2) return false;
        int n3 = IItemHandlerKt.get((IItemHandler)((IItemHandler)this.getInput()), (int)0).func_190916_E();
        LiquifierRecipe liquifierRecipe2 = this.currentRecipe;
        if (liquifierRecipe2 == null) {
            Intrinsics.throwNpe();
        }
        if (n3 < liquifierRecipe2.getInput().func_190916_E()) return false;
        FluidStack fluidStack = this.outputTank.getFluid();
        Object object2 = fluidStack != null ? fluidStack.getFluid() : null;
        object2 = recipeOutput.getFluid();
        if (object2 == null) {
            object2 = false;
        }
        if (Intrinsics.areEqual((Object)object, (Object)object2)) return true;
        if (this.outputTank.getFluid() != null) return false;
        return true;
    }

    public final void process() {
        Integer n = ConfigHandler.INSTANCE.getLiquifierProcessingTicks();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        if (this.progressTicks < n) {
            int n2 = this.progressTicks;
            this.progressTicks = n2 + 1;
        } else {
            this.progressTicks = 0;
            LiquifierRecipe liquifierRecipe = this.currentRecipe;
            if (liquifierRecipe == null) {
                Intrinsics.throwNpe();
            }
            this.outputTank.fillInternal(liquifierRecipe.getOutput().copy(), true);
            ItemStack itemStack = IItemHandlerKt.get((IItemHandler)((IItemHandler)this.getInput()), (int)0);
            LiquifierRecipe liquifierRecipe2 = this.currentRecipe;
            if (liquifierRecipe2 == null) {
                Intrinsics.throwNpe();
            }
            itemStack.func_190918_g(liquifierRecipe2.getInput().func_190916_E());
        }
        IEnergyStorage iEnergyStorage = this.getEnergyStorage();
        Integer n3 = ConfigHandler.INSTANCE.getLiquifierEnergyPerTick();
        if (n3 == null) {
            Intrinsics.throwNpe();
        }
        iEnergyStorage.extractEnergy(n3.intValue(), false);
    }

    public TileLiquifier() {
        Integer n = ConfigHandler.INSTANCE.getLiquifierEnergyCapacity();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.$$delegate_0 = new EnergyTileImpl(n.intValue());
        this.initInventoryCapability(1, 0);
        this.outputTank = new FluidTank(10000){

            public boolean canFillFluidType(@Nullable FluidStack fluid) {
                boolean bl;
                block3: {
                    Iterable $receiver$iv = ModRecipes.INSTANCE.getLiquifierRecipes();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            LiquifierRecipe it = (LiquifierRecipe)element$iv;
                            FluidStack fluidStack = fluid;
                            if (!Intrinsics.areEqual((Object)it.getOutput().getFluid(), (Object)(fluidStack != null ? fluidStack.getFluid() : null))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            protected void onContentsChanged() {
                super.onContentsChanged();
                this.markDirtyGUI();
                this.updateRecipe();
            }
        };
        this.outputTank.setTileEntity((TileEntity)this);
        this.outputTank.setCanFill(false);
        this.outputTank.setCanDrain(true);
    }

    public int getGuiHeight() {
        return IGuiTile.DefaultImpls.getGuiHeight((IGuiTile)this);
    }

    public int getGuiWidth() {
        return IGuiTile.DefaultImpls.getGuiWidth((IGuiTile)this);
    }

    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkParameterIsNotNull((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

