/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.MathHelper;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.misc.IAgriDisplayable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import com.infinityraider.agricraft.farming.PlantStats;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.utility.MessageUtil;
import com.infinityraider.infinitylib.utility.WorldHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCrop
extends TileEntityBase
implements IAgriCrop,
IDebuggable,
IAgriDisplayable {
    private AgriSeed seed;
    private int growthStage;
    private boolean crossCrop = false;

    @Override
    @Nonnull
    public MethodResult onGrowthTick() {
        if (this.isRemote()) {
            return MethodResult.PASS;
        }
        if (this.isCrossCrop() && (double)AgriCraftConfig.crossOverChance > this.getRandom().nextDouble()) {
            this.crossOver();
            return MethodResult.SUCCESS;
        }
        if (!this.hasSeed()) {
            this.spawn();
            return MethodResult.SUCCESS;
        }
        if (this.isMature()) {
            this.spread();
            return MethodResult.SUCCESS;
        }
        if ((this.seed.getPlant().getGrowthChanceBase() + (double)this.seed.getStat().getGrowth() * this.seed.getPlant().getGrowthChanceBonus()) * (double)AgriCraftConfig.growthMultiplier > this.getRandom().nextDouble()) {
            this.applyGrowthTick();
            return MethodResult.SUCCESS;
        }
        return MethodResult.FAIL;
    }

    @Override
    @Nonnull
    public MethodResult onApplySeeds(@Nonnull AgriSeed seed, @Nullable EntityPlayer player) {
        Preconditions.checkNotNull((Object)seed, (Object)"`7Cannot apply a null seed!`r");
        if (this.isRemote()) {
            return MethodResult.PASS;
        }
        if (this.isCrossCrop() || this.hasSeed()) {
            return MethodResult.FAIL;
        }
        if (!seed.getPlant().getGrowthRequirement().hasValidSoil((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
            MessageUtil.messagePlayer((EntityPlayer)player, (String)"`7The soil is not valid for this seed. You can't plant it here.`r", (Object[])new Object[0]);
            return MethodResult.FAIL;
        }
        if (!seed.getPlant().getGrowthRequirement().hasValidConditions((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
            MessageUtil.messagePlayer((EntityPlayer)player, (String)"`7Caution: This plant has additional requirements that are unmet.`r", (Object[])new Object[0]);
        }
        if (!seed.getPlant().getGrowthRequirement().hasValidLight(this.func_145831_w(), this.field_174879_c)) {
            MessageUtil.messagePlayer((EntityPlayer)player, (String)"`7Caution: This plant won't grow with the current light level.`r", (Object[])new Object[0]);
        }
        this.setSeed(seed);
        return MethodResult.SUCCESS;
    }

    @Override
    @Nonnull
    public MethodResult onApplyCrops(@Nullable EntityPlayer player) {
        if (this.isRemote()) {
            return MethodResult.PASS;
        }
        if (this.isCrossCrop() || this.hasSeed()) {
            return MethodResult.FAIL;
        }
        boolean wasSet = this.setCrossCrop(true);
        return wasSet ? MethodResult.SUCCESS : MethodResult.FAIL;
    }

    @Override
    @Nonnull
    public MethodResult onBroken(@Nonnull Consumer<ItemStack> consumer, @Nullable EntityPlayer player) {
        Preconditions.checkNotNull(consumer);
        if (this.isRemote()) {
            return MethodResult.PASS;
        }
        if (player == null || !player.func_184812_l_()) {
            this.getDrops(consumer, true, true, true);
        }
        this.func_145831_w().func_175713_t(this.field_174879_c);
        this.func_145831_w().func_175698_g(this.field_174879_c);
        return MethodResult.SUCCESS;
    }

    public void getDrops(@Nonnull Consumer<ItemStack> consumer, boolean includeCropSticks, boolean includeSeeds, boolean includeProducts) {
        Preconditions.checkNotNull(consumer);
        if (includeCropSticks) {
            consumer.accept(new ItemStack((Item)AgriItems.getInstance().CROPS, this.isCrossCrop() ? 2 : 1));
        }
        if (this.hasSeed()) {
            if (includeSeeds && this.seed.getPlant().getSeedDropChanceBase() + (double)this.growthStage * this.seed.getPlant().getSeedDropChanceBonus() > this.getRandom().nextDouble()) {
                consumer.accept(this.getSeed().toStack());
            }
            if (includeProducts && this.isMature()) {
                for (int trials = (this.seed.getStat().getGain() + 3) / 3; trials > 0; --trials) {
                    this.seed.getPlant().getHarvestProducts(consumer, this, this.seed.getStat(), this.getRandom());
                }
            }
        }
    }

    @Override
    public boolean hasSeed() {
        return this.seed != null;
    }

    @Override
    public AgriSeed getSeed() {
        return this.seed;
    }

    @Override
    public boolean acceptsSeed(@Nullable AgriSeed seed) {
        return !this.crossCrop && (this.seed == null || seed == null);
    }

    @Override
    public boolean setSeed(@Nullable AgriSeed seed) {
        if (Objects.equal((Object)this.seed, (Object)seed)) {
            return false;
        }
        this.seed = seed;
        this.growthStage = 0;
        this.markForUpdate();
        return true;
    }

    @Override
    public BlockPos getCropPos() {
        return this.func_174877_v();
    }

    @Override
    public World getCropWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean isCrossCrop() {
        return this.crossCrop;
    }

    @Override
    public boolean setCrossCrop(boolean status) {
        if (this.isRemote()) {
            return false;
        }
        if (this.hasSeed()) {
            return false;
        }
        if (this.crossCrop == status) {
            return false;
        }
        this.crossCrop = status;
        SoundType type = Blocks.field_150344_f.getSoundType(null, null, null, null);
        this.func_145831_w().func_184148_a(null, (double)((float)this.xCoord() + 0.5f), (double)((float)this.yCoord() + 0.5f), (double)((float)this.zCoord() + 0.5f), type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
        this.markForUpdate();
        return true;
    }

    @Override
    public int getGrowthStage() {
        return this.growthStage;
    }

    @Override
    public boolean setGrowthStage(int stage) {
        if (this.isRemote()) {
            return false;
        }
        if (this.hasSeed()) {
            stage = MathHelper.inRange(stage, 0, this.seed.getPlant().getGrowthStages() - 1);
        } else if (stage != 0) {
            AgriCore.getCoreLogger().warn("Can't set a non-zero growth stage when a crop has no seed!", new Object[0]);
            stage = 0;
        }
        if (stage != this.growthStage) {
            this.growthStage = stage;
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean isFertile(@Nullable IAgriPlant plant) {
        return plant != null && this.func_145831_w().func_175623_d(this.field_174879_c.func_177984_a()) && plant.getGrowthRequirement().isMet(this.func_145831_w(), this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCropHeight() {
        return this.hasSeed() ? this.getSeed().getPlant().getHeight(this.func_145832_p()) : 0.8125f;
    }

    @Override
    public boolean isMature() {
        return this.hasSeed() && this.getGrowthStage() + 1 >= this.getSeed().getPlant().getGrowthStages();
    }

    @Override
    @Nonnull
    public Optional<IAgriSoil> getSoil() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c.func_177977_b());
        return AgriApi.getSoilRegistry().get(state);
    }

    public boolean spawn() {
        if (this.isRemote()) {
            return false;
        }
        if (this.hasSeed()) {
            return false;
        }
        for (IAgriPlant p : AgriApi.getPlantRegistry().all()) {
            if (!(p.getSpawnChance() > this.getRandom().nextDouble()) || !this.isFertile(p)) continue;
            this.setCrossCrop(false);
            this.setSeed(new AgriSeed(p, new PlantStats()));
            return true;
        }
        return false;
    }

    public boolean spread() {
        if (this.isRemote()) {
            return false;
        }
        if (this.seed == null) {
            return false;
        }
        IAgriPlant plant = this.seed.getPlant();
        for (IAgriCrop crop : WorldHelper.getTileNeighbors((World)this.func_145831_w(), (BlockPos)this.field_174879_c, IAgriCrop.class)) {
            if (!(plant.getSpreadChance() > this.getRandom().nextDouble()) || !plant.getGrowthRequirement().hasValidSoil((IBlockAccess)this.func_145831_w(), crop.getCropPos())) continue;
            AgriSeed other = crop.getSeed();
            if (other == null) {
                if (crop.isCrossCrop()) continue;
                crop.setSeed(this.seed);
                return true;
            }
            if (!TileEntityCrop.canOvertake(this.seed, other, this.getRandom())) continue;
            crop.setCrossCrop(false);
            crop.setSeed(this.seed);
            return true;
        }
        return false;
    }

    public static boolean canOvertake(@Nonnull AgriSeed overtaker, @Nonnull AgriSeed victim, @Nonnull Random rand) {
        return overtaker.getPlant().isAggressive() && (double)victim.getStat().getStrength() < (double)overtaker.getStat().getStrength() * rand.nextDouble();
    }

    @Override
    public boolean acceptsFertilizer(@Nullable IAgriFertilizer fertilizer) {
        if (fertilizer == null) {
            return false;
        }
        if (this.crossCrop) {
            return AgriCraftConfig.fertilizerMutation && fertilizer.canTriggerMutation();
        }
        if (!this.hasSeed()) {
            return true;
        }
        return this.getSeed().getPlant().isFertilizable();
    }

    @Override
    @Nonnull
    public MethodResult onApplyFertilizer(@Nullable IAgriFertilizer fertilizer, @Nonnull Random rand) {
        Preconditions.checkNotNull((Object)rand);
        if (this.isRemote()) {
            return MethodResult.PASS;
        }
        if (!this.acceptsFertilizer(fertilizer)) {
            AgriCore.getCoreLogger().warn("onApplyFertilizer should not be called if acceptFertilizer is false!", new Object[0]);
            return MethodResult.FAIL;
        }
        this.onGrowthTick();
        return MethodResult.SUCCESS;
    }

    @Override
    @Nonnull
    public MethodResult onHarvest(@Nonnull Consumer<ItemStack> consumer, @Nullable EntityPlayer player) {
        Preconditions.checkNotNull(consumer);
        if (this.isRemote()) {
            return MethodResult.PASS;
        }
        if (this.isCrossCrop()) {
            if (this.setCrossCrop(false)) {
                consumer.accept(new ItemStack((Item)AgriItems.getInstance().CROPS, 1));
            }
            return MethodResult.SUCCESS;
        }
        if (this.canBeHarvested()) {
            this.getDrops(consumer, false, false, true);
            this.setGrowthStage(0);
            return MethodResult.SUCCESS;
        }
        return MethodResult.PASS;
    }

    @Override
    public boolean onRaked(@Nonnull Consumer<ItemStack> consumer, @Nullable EntityPlayer player) {
        Preconditions.checkNotNull(consumer);
        if (!this.isRemote() && this.canBeRaked()) {
            this.getDrops(consumer, false, AgriCraftConfig.enableRakingSeedDrops, AgriCraftConfig.enableRakingItemDrops);
            this.setSeed(null);
            return true;
        }
        return false;
    }

    public void writeTileNBT(@Nonnull NBTTagCompound tag) {
        Preconditions.checkNotNull((Object)tag);
        tag.func_74757_a("agri_cross_crop", this.crossCrop);
        tag.func_74768_a("agri_meta", this.growthStage);
        if (this.hasSeed()) {
            this.getSeed().getStat().writeToNBT(tag);
            tag.func_74778_a("agri_seed", this.getSeed().getPlant().getId());
        }
    }

    public void readTileNBT(@Nonnull NBTTagCompound tag) {
        Preconditions.checkNotNull((Object)tag);
        IAgriStat stat = AgriApi.getStatRegistry().valueOf(tag).orElse(null);
        IAgriPlant plant = AgriApi.getPlantRegistry().get(tag.func_74779_i("agri_seed")).orElse(null);
        this.seed = stat != null && plant != null ? new AgriSeed(plant, stat) : null;
        this.growthStage = tag.func_74762_e("agri_meta");
        this.crossCrop = tag.func_74767_n("agri_cross_crop");
    }

    public void applyGrowthTick() {
        if (this.isRemote()) {
            return;
        }
        if (!this.hasSeed()) {
            return;
        }
        if (this.isMature()) {
            return;
        }
        if (!this.isFertile()) {
            return;
        }
        this.setGrowthStage(this.growthStage + 1);
    }

    public void crossOver() {
        AgriApi.getMutationEngine().attemptCross(this, this.func_145831_w().field_73012_v);
    }

    public void addServerDebugInfo(@Nonnull Consumer<String> consumer) {
        Preconditions.checkNotNull(consumer);
        consumer.accept("CROP:");
        if (this.crossCrop) {
            consumer.accept(" - This is a crosscrop");
        } else if (this.hasSeed()) {
            IAgriPlant plant = this.getSeed().getPlant();
            IAgriStat stat = this.getSeed().getStat();
            if (plant.isWeed()) {
                consumer.accept(" - This crop has weeds");
            } else {
                consumer.accept(" - This crop has a plant");
            }
            consumer.accept(" - Plant: " + plant.getPlantName());
            consumer.accept(" - Id: " + plant.getId());
            consumer.accept(" - Stage: " + this.getGrowthStage());
            consumer.accept(" - Stages: " + plant.getGrowthStages());
            consumer.accept(" - Meta: " + this.getGrowthStage());
            consumer.accept(" - Growth: " + stat.getGrowth());
            consumer.accept(" - Gain: " + stat.getGain());
            consumer.accept(" - Strength: " + stat.getStrength());
            consumer.accept(" - Fertile: " + this.isFertile());
            consumer.accept(" - Mature: " + this.isMature());
            consumer.accept(" - AgriSoil: " + plant.getGrowthRequirement().getSoils().stream().findFirst().map(IAgriSoil::getId).orElse("None"));
        } else {
            consumer.accept(" - This crop has no plant");
        }
    }

    public void addClientDebugInfo(@Nonnull Consumer<String> consumer) {
        Preconditions.checkNotNull(consumer);
        if (this.hasSeed()) {
            consumer.accept(" - Texture: " + this.getSeed().getPlant().getPrimaryPlantTexture(this.getGrowthStage()).toString());
        }
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<String> information) {
        Preconditions.checkNotNull(information);
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.soil") + ": " + this.getSoil().map(IAgriSoil::getName).orElse("Unknown"));
        if (this.hasSeed()) {
            IAgriPlant plant = this.getSeed().getPlant();
            IAgriStat stat = this.getSeed().getStat();
            information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.seed") + ": " + plant.getSeedName());
            if (this.isMature()) {
                information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.growth") + ": " + AgriCore.getTranslator().translate("agricraft_tooltip.mature"));
            } else {
                information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.growth") + ": " + (int)(100.0 * (double)(this.getGrowthStage() + 1) / (double)plant.getGrowthStages()) + "%");
            }
            if (stat.isAnalyzed()) {
                stat.addStats(information);
            } else {
                information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.analyzed"));
            }
            information.accept(AgriCore.getTranslator().translate(this.isFertile() ? "agricraft_tooltip.fertile" : "agricraft_tooltip.notFertile"));
        } else {
            information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.empty"));
        }
    }
}

