/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.api.v1.util.AgriSideMetaMatrix;
import com.infinityraider.agricraft.blocks.irrigation.BlockWaterTank;
import com.infinityraider.agricraft.renderers.blocks.RenderBlockCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityTank;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.render.RenderUtilBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTank
extends RenderBlockCustomWood<BlockWaterTank, TileEntityTank> {
    static final float A = 0.001f;
    static final float B = 15.999f;

    public RenderTank(BlockWaterTank block) {
        super(block, block.createNewTileEntity(null, 0), true, true, true);
    }

    private void renderBottom(ITessellator tessellator, byte connection, TextureAtlasSprite icon) {
        if (connection < 2) {
            tessellator.drawScaledFace(0.001f, 0.001f, 15.999f, 15.999f, EnumFacing.DOWN, icon, 0.0f);
            tessellator.drawScaledFace(0.001f, 0.001f, 15.999f, 15.999f, EnumFacing.UP, icon, 1.0f);
        }
    }

    private void renderSide(ITessellator tessellator, EnumFacing dir, byte connection, TextureAtlasSprite icon) {
        if (connection < 0 || connection > 1) {
            return;
        }
        boolean xAxis = dir.func_176740_k() == EnumFacing.Axis.X;
        int index = xAxis ? dir.func_82601_c() : dir.func_82599_e();
        int min = index < 0 ? 0 : 14;
        int max = index < 0 ? 2 : 16;
        tessellator.drawScaledFace(xAxis ? (float)min : 0.0f, xAxis ? 0.0f : (float)min, xAxis ? (float)max : 16.0f, xAxis ? 16.0f : (float)max, EnumFacing.UP, icon, 16.0f);
        if (connection == 0) {
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
        } else {
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 5.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 5.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(0.0f, 5.0f, 5.0f, 12.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 5.0f, 5.0f, 12.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(11.0f, 5.0f, 16.0f, 12.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(11.0f, 5.0f, 16.0f, 12.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(0.0f, 12.0f, 16.0f, 16.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 12.0f, 16.0f, 16.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(xAxis ? (float)min : 5.0f, xAxis ? 5.0f : (float)min, xAxis ? (float)max : 11.0f, xAxis ? 11.0f : (float)max, EnumFacing.UP, icon, 5.0f);
            tessellator.drawScaledFace(xAxis ? (float)min : 5.0f, xAxis ? 5.0f : (float)min, xAxis ? (float)max : 11.0f, xAxis ? 11.0f : (float)max, EnumFacing.DOWN, icon, 12.0f);
            EnumFacing left = xAxis ? EnumFacing.NORTH : EnumFacing.WEST;
            EnumFacing right = left.func_176734_d();
            tessellator.drawScaledFace((float)min, 5.0f, (float)max, 12.0f, left, icon, 11.0f);
            tessellator.drawScaledFace((float)min, 5.0f, (float)max, 12.0f, right, icon, 5.0f);
        }
    }

    @Override
    protected void renderWorldBlockWoodDynamic(ITessellator tessellator, World world, BlockPos pos, BlockWaterTank block, TileEntityTank tank, TextureAtlasSprite sprite) {
        int level = tank.getFluidHeight();
        if (level > 0) {
            float y = (float)(level * 16) / 1000.0f - 0.001f;
            int l = RenderUtilBase.getMixedBrightness((World)tank.func_145831_w(), (BlockPos)tank.func_174877_v(), (Block)Blocks.field_150355_j);
            tessellator.setBrightness(l);
            tessellator.setAlpha(0.39f);
            TextureAtlasSprite waterIcon = BaseIcons.WATER_STILL.getIcon();
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.UP, waterIcon, y);
        }
    }

    @Override
    protected void renderWorldBlockWoodStatic(ITessellator tess, IExtendedBlockState state, BlockWaterTank block, EnumFacing face, TextureAtlasSprite sprite) {
        AgriSideMetaMatrix connections = new AgriSideMetaMatrix();
        connections.readFromBlockState((IBlockState)state);
        for (EnumFacing side : EnumFacing.field_176754_o) {
            this.renderSide(tess, side, connections.get(side), sprite);
        }
        this.renderBottom(tess, connections.get(EnumFacing.DOWN), sprite);
    }

    @Override
    protected void renderInventoryBlockWood(ITessellator tess, World world, IBlockState state, BlockWaterTank block, TileEntityTank tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type, TextureAtlasSprite sprite) {
        this.renderSide(tess, EnumFacing.NORTH, (byte)0, sprite);
        this.renderSide(tess, EnumFacing.EAST, (byte)0, sprite);
        this.renderSide(tess, EnumFacing.SOUTH, (byte)0, sprite);
        this.renderSide(tess, EnumFacing.WEST, (byte)0, sprite);
        this.renderBottom(tess, (byte)0, sprite);
    }

    public boolean applyAmbientOcclusion() {
        return true;
    }
}

