/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.mutation.IAgriCrossStrategy;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpreadStrategy
implements IAgriCrossStrategy {
    @Override
    public double getRollChance() {
        return Math.abs(1.0f - AgriCraftConfig.mutationChance);
    }

    @Override
    @Nonnull
    public Optional<AgriSeed> executeStrategy(@Nonnull IAgriCrop crop, @Nonnull Random rand) {
        int index;
        AgriSeed seed;
        List allNeighbours = WorldHelper.getTileNeighbors((World)crop.getCropWorld(), (BlockPos)crop.getCropPos(), IAgriCrop.class);
        ArrayList<IAgriCrop> matureNeighbours = new ArrayList<IAgriCrop>(allNeighbours);
        matureNeighbours.removeIf(c -> !c.isMature());
        if (!matureNeighbours.isEmpty() && (seed = ((IAgriCrop)matureNeighbours.get(index = rand.nextInt(matureNeighbours.size()))).getSeed()) != null && rand.nextDouble() < seed.getPlant().getSpreadChance()) {
            return AgriApi.getStatCalculatorRegistry().valueOf(seed.getPlant()).map(calc -> calc.calculateSpreadStats(seed.getPlant(), allNeighbours)).map(stat -> new AgriSeed(seed.getPlant(), (IAgriStat)stat));
        }
        return Optional.empty();
    }
}

