/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.container;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.network.MessageContainerSeedStorage;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageControllable;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageController;
import com.infinityraider.agricraft.tiles.storage.SeedStorageSlot;
import com.infinityraider.infinitylib.container.ContainerTileBase;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public abstract class ContainerSeedStorageBase<T extends TileEntity>
extends ContainerTileBase<T> {
    public ContainerSeedStorageBase(T tile, InventoryPlayer inventory, int xOffset, int yOffset) {
        super(tile, inventory, xOffset, yOffset);
    }

    public abstract boolean addSeedToStorage(ItemStack var1);

    public abstract List<ItemStack> getSeedEntries();

    public abstract List<SeedStorageSlot> getSeedSlots(AgriSeed var1);

    public Optional<ISeedStorageControllable> getControllable(ItemStack stack) {
        if (this.getTile() instanceof ISeedStorageController) {
            return ((ISeedStorageController)this.getTile()).getControllable(stack);
        }
        if (this.getTile() instanceof ISeedStorageControllable) {
            return Optional.of((ISeedStorageControllable)this.getTile());
        }
        return Optional.empty();
    }

    public NonNullList<ItemStack> func_75138_a() {
        return super.func_75138_a();
    }

    public void moveStackFromTileEntityToPlayer(int slotId, ItemStack stack) {
        ISeedStorageControllable controllable = this.getControllable(stack).orElse(null);
        if (controllable == null) {
            return;
        }
        ItemStack stackToMove = controllable.getStackForSlotId(slotId);
        if (stack.func_190926_b()) {
            return;
        }
        if (stackToMove.func_190926_b()) {
            return;
        }
        stackToMove.func_190920_e(stack.func_190916_E() > stackToMove.func_190916_E() ? stackToMove.func_190916_E() : stack.func_190916_E());
        stackToMove.func_77982_d(controllable.getStackForSlotId(slotId).func_77978_p());
        if (this.func_75135_a(stackToMove, 0, 36, false)) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                new MessageContainerSeedStorage(stack, slotId).sendToServer();
            } else {
                controllable.decreaseStackSizeInSlot(slotId, stack.func_190916_E() - stackToMove.func_190916_E());
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int clickedSlot) {
        ItemStack originalStackInSlot = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlot);
        if (slot != null && slot.func_75216_d()) {
            ItemStack notMergedStack = slot.func_75211_c();
            originalStackInSlot = notMergedStack.func_77946_l();
            AgriSeed seed = AgriApi.getSeedRegistry().valueOf(notMergedStack).orElse(null);
            if (seed != null && seed.getStat().isAnalyzed()) {
                ISeedStorageControllable controllable = this.getControllable(notMergedStack).orElse(null);
                if (controllable != null && controllable.hasLockedSeed()) {
                    ItemStack locked = controllable.getLockedSeed().map(AgriSeed::toStack).orElse(ItemStack.field_190927_a);
                    if (notMergedStack.func_77973_b() != locked.func_77973_b() || notMergedStack.func_77952_i() != locked.func_77952_i()) {
                        return ItemStack.field_190927_a;
                    }
                }
                if (this.addSeedToStorage(notMergedStack)) {
                    notMergedStack.func_190920_e(0);
                } else {
                    return ItemStack.field_190927_a;
                }
            }
            if (notMergedStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (notMergedStack.func_190916_E() == originalStackInSlot.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, notMergedStack);
        }
        return originalStackInSlot;
    }

    protected boolean func_75135_a(ItemStack stack, int startSlot, int endSlot, boolean iterateBackwards) {
        ItemStack currentStack;
        Slot currentSlot;
        int k;
        boolean flag = false;
        int n = k = iterateBackwards ? endSlot - 1 : startSlot;
        while (stack.func_190916_E() > 0 && (!iterateBackwards && k < endSlot || iterateBackwards && k >= startSlot)) {
            currentSlot = (Slot)this.field_75151_b.get(k);
            currentStack = currentSlot.func_75211_c();
            if (currentStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77952_i() == currentStack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)currentStack)) {
                int l = currentStack.func_190916_E() + stack.func_190916_E();
                if (l <= stack.func_77976_d()) {
                    stack.func_190920_e(0);
                    currentStack.func_190920_e(l);
                    currentSlot.func_75218_e();
                    flag = true;
                } else if (currentStack.func_190916_E() < stack.func_77976_d()) {
                    stack.func_190920_e(stack.func_190916_E() - stack.func_77976_d() - currentStack.func_190916_E());
                    currentStack.func_190920_e(stack.func_77976_d());
                    currentSlot.func_75218_e();
                    flag = true;
                }
            }
            k = iterateBackwards ? k - 1 : k + 1;
        }
        if (stack.func_190916_E() > 0) {
            int n2 = k = iterateBackwards ? endSlot - 1 : startSlot;
            while (!iterateBackwards && k < endSlot || iterateBackwards && k >= startSlot) {
                currentSlot = (Slot)this.field_75151_b.get(k);
                currentStack = currentSlot.func_75211_c();
                if (currentStack.func_190926_b()) {
                    currentSlot.func_75215_d(stack.func_77946_l());
                    currentSlot.func_75218_e();
                    stack.func_190920_e(0);
                    flag = true;
                    break;
                }
                k = iterateBackwards ? k - 1 : k + 1;
            }
        }
        return flag;
    }
}

