/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.commands;

import com.agricraft.agricore.util.TypeHelper;
import com.google.common.collect.ComparisonChain;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.utility.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandNbt
implements ICommand {
    public String func_71517_b() {
        return "ac.nbt";
    }

    public String func_71518_a(ICommandSender ics) {
        return "ac.nbt <list|get> <name>";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer ms, ICommandSender ics, String[] arguments) throws CommandException {
        if (arguments.length < 1) {
            throw new CommandException("Too few arguments to command! Expected \"list\" or \"get\" as first argument!", new Object[0]);
        }
        String action = arguments[0].trim().toLowerCase();
        if (action.equals("list") && arguments.length != 1) {
            throw new CommandException("Incorrect number of arguments!", new Object[0]);
        }
        if (action.equals("get") && arguments.length != 2) {
            throw new CommandException("Incorrect number of arguments!", new Object[0]);
        }
        EntityPlayer player = TypeHelper.cast(ics.func_174793_f(), EntityPlayer.class).orElseThrow(() -> new CommandException("Command must be invoked by a player!", new Object[0]));
        ItemStack stack = Optional.ofNullable(player.func_184614_ca()).filter(StackHelper::isValid).orElseThrow(() -> new CommandException("Player must be holding valid itemstack to be used as a target!", new Object[0]));
        NBTTagCompound tag = StackHelper.getTag(stack);
        switch (action) {
            case "list": {
                this.listNbt(player, stack, tag);
                return;
            }
            case "get": {
                String target = arguments[1].trim().toLowerCase();
                this.getNbt(player, stack, tag, target);
                return;
            }
        }
        throw new CommandException("Invalid action: \"%s\"!", new Object[]{action});
    }

    private void listNbt(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, @Nonnull NBTTagCompound tag) throws CommandException {
        for (String key : tag.func_150296_c()) {
            NBTBase entry = tag.func_74781_a(key);
            String type = NBTBase.field_82578_b[entry.func_74732_a()];
            MessageUtil.messagePlayer((EntityPlayer)player, (String)"`l`3{0}`r `b{1}`r: `2{2}`r", (Object[])new Object[]{type, key, entry});
        }
    }

    private void getNbt(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, @Nonnull NBTTagCompound tag, @Nonnull String key) throws CommandException {
        if (!tag.func_74764_b(key)) {
            throw new CommandException("Active player stack does not have NBT tag: \"%s\"!", new Object[]{key});
        }
        NBTBase entry = tag.func_74781_a(key);
        String type = NBTBase.field_82578_b[entry.func_74732_a()];
        MessageUtil.messagePlayer((EntityPlayer)player, (String)"`l`3{0}`r `b{1}`r: `2{2}`r", (Object[])new Object[]{type, key, entry});
    }

    public boolean func_184882_a(MinecraftServer ms, ICommandSender ics) {
        return TypeHelper.cast(ics.func_174793_f(), EntityPlayer.class).filter(EntityPlayer::func_184812_l_).isPresent();
    }

    public List<String> func_184883_a(MinecraftServer ms, ICommandSender ics, String[] arguments, BlockPos bp) {
        ArrayList<String> completions = new ArrayList<String>();
        switch (arguments.length) {
            case 1: {
                completions.add("get");
                completions.add("list");
                break;
            }
            case 2: {
                if (!arguments[0].trim().toLowerCase().equals("get")) break;
                TypeHelper.cast(ics.func_174793_f(), EntityPlayer.class).map(EntityLivingBase::func_184614_ca).map(ItemStack::func_77978_p).ifPresent(tag -> tag.func_150296_c().forEach(completions::add));
            }
        }
        return completions;
    }

    public boolean func_82358_a(String[] strings, int i) {
        return false;
    }

    public int compareTo(ICommand o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.func_71517_b()), (Comparable)((Object)o.func_71517_b())).result();
    }
}

