/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.api.v1.misc.IAgriConnectable;
import com.infinityraider.agricraft.blocks.irrigation.BlockWaterChannel;
import com.infinityraider.agricraft.items.blocks.ItemBlockAgricraft;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderSprinkler;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.agricraft.tiles.irrigation.TileEntitySprinkler;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.infinitylib.block.BlockTileCustomRenderedBase;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSprinkler
extends BlockTileCustomRenderedBase<TileEntitySprinkler> {
    public static final AxisAlignedBB BOUNDS_SPRINKLER = new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.25, 0.75);
    private final ItemBlockAgricraft itemBlock;

    public BlockSprinkler() {
        super("sprinkler", Material.field_151573_f);
        this.func_149647_a(AgriTabs.TAB_AGRICRAFT);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        this.itemBlock = new ItemBlockAgricraft((Block)this);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos.func_177984_a(), IAgriConnectable.class).ifPresent(IAgriConnectable::refreshConnections);
    }

    public TileEntitySprinkler createNewTileEntity(World world, int meta) {
        return new TileEntitySprinkler();
    }

    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos.func_177984_a(), TileEntityChannel.class);
        return ((IExtendedBlockState)state).withProperty(AgriProperties.CUSTOM_WOOD_TYPE, (Object)tile.map(TileEntityCustomWood::getMaterial).orElse(CustomWoodTypeRegistry.DEFAULT));
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
            world.func_175713_t(pos);
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float f, int i) {
        if (!world.field_72995_K) {
            ItemStack drop = new ItemStack((Block)this, 1);
            BlockSprinkler.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
        }
    }

    public void observedNeighborChange(IBlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175713_t(pos);
            world.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntitySprinkler.class).filter(TileEntitySprinkler::isConnected).isPresent();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getBlockModelResourceLocation() {
        return new ModelResourceLocation("agricraft".toLowerCase() + ":" + this.getInternalName());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() instanceof BlockWaterChannel && state.func_177230_c().func_149688_o(state) == Material.field_151579_a;
    }

    public Optional<ItemBlockAgricraft> getItemBlock() {
        return Optional.of(this.itemBlock);
    }

    public boolean isEnabled() {
        return AgriCraftConfig.enableIrrigation;
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[0];
    }

    public final IUnlistedProperty[] getUnlistedPropertyArray() {
        return new IUnlistedProperty[]{AgriProperties.CUSTOM_WOOD_TYPE};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, @Nullable Entity entity, boolean isActualState) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)BOUNDS_SPRINKLER);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BOUNDS_SPRINKLER;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderSprinkler getRenderer() {
        return new RenderSprinkler(this);
    }
}

