/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public final class UnlistedPropertyByte
implements IUnlistedProperty<Byte> {
    private final String name;
    private final byte min;
    private final byte max;

    public UnlistedPropertyByte(@Nonnull String name) {
        this(name, -128, 127);
    }

    public UnlistedPropertyByte(@Nonnull String name, byte min, byte max) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.min = min;
        this.max = max;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid(Byte v) {
        return v >= this.min && v <= this.max;
    }

    public Class<Byte> getType() {
        return Byte.class;
    }

    public String valueToString(Byte v) {
        return Byte.toString(v);
    }

    public byte getValue(@Nonnull IBlockState state, byte orElse) {
        Byte wrapped;
        Preconditions.checkNotNull((Object)state);
        if (state instanceof IExtendedBlockState && (wrapped = (Byte)((IExtendedBlockState)state).getValue((IUnlistedProperty)this)) != null) {
            return wrapped;
        }
        return orElse;
    }

    @Nonnull
    public <T extends IBlockState> T setValue(@Nonnull T state, byte value) {
        Preconditions.checkNotNull(state);
        if (state instanceof IExtendedBlockState) {
            return (T)((IExtendedBlockState)state).withProperty((IUnlistedProperty)this, (Object)value);
        }
        return state;
    }
}

