/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class FuzzyStack {
    @Nonnull
    private final ItemStack stack;
    @Nonnull
    private final NBTTagCompound tags;
    private final boolean ignoreMeta;
    private final boolean useOreDict;
    @Nonnull
    private final List<String> ignoreTags;

    public FuzzyStack(@Nonnull ItemStack stack) {
        this(stack, false, false, new String[0]);
    }

    public FuzzyStack(@Nonnull ItemStack stack, boolean ignoreMeta, boolean useOreDict, String ... ignoreTags) {
        this(stack, ignoreMeta, useOreDict, Arrays.asList(ignoreTags));
    }

    public FuzzyStack(@Nonnull ItemStack stack, boolean ignoreMeta, boolean useOreDict, @Nullable List<String> ignoreTags) {
        Objects.requireNonNull(stack, "The Itemstack must not be null for FuzzyStacks!");
        Objects.requireNonNull(stack.func_77973_b(), "The Item must not be null for FuzzyStacks!");
        this.stack = stack.func_77946_l();
        this.tags = Optional.ofNullable(stack.func_77978_p()).orElseGet(NBTTagCompound::new);
        this.ignoreTags = Optional.ofNullable(ignoreTags).orElseGet(Collections::emptyList);
        this.ignoreMeta = ignoreMeta;
        this.useOreDict = useOreDict;
        this.stack.func_77982_d(this.stripTags(this.stack.func_77978_p()));
    }

    @Nonnull
    public static final Optional<FuzzyStack> from(@Nullable IBlockState state) {
        return Optional.ofNullable(state).map(s -> new ItemStack(s.func_177230_c(), 1, s.func_177230_c().func_176201_c(s))).filter(i -> i.func_77973_b() != null).map(FuzzyStack::new);
    }

    @Nonnull
    public static final Optional<FuzzyStack> from(@Nullable ItemStack stack) {
        return Optional.ofNullable(stack).filter(s -> s.func_77973_b() != null).map(FuzzyStack::new);
    }

    @Nonnull
    public ItemStack toStack() {
        ItemStack copy = this.stack.func_77946_l();
        copy.func_77982_d(this.tags.func_150296_c().isEmpty() ? null : this.tags.func_74737_b());
        return copy;
    }

    @Nonnull
    public Item getItem() {
        return this.stack.func_77973_b();
    }

    @Nonnull
    public int getMeta() {
        return this.stack.func_77960_j();
    }

    @Nonnull
    public NBTTagCompound getTagCompound() {
        return this.tags.func_74737_b();
    }

    public boolean isMetaEqual(@Nullable ItemStack other) {
        return other != null && (this.ignoreMeta || this.getMeta() == other.func_77960_j());
    }

    public boolean isMetaEqual(@Nullable FuzzyStack other) {
        return other != null && (this.ignoreMeta || other.ignoreMeta || this.getMeta() == other.getMeta());
    }

    public boolean isTagsEqual(@Nullable ItemStack other) {
        return other != null && this.getTagCompound().equals((Object)this.stripTags(other.func_77978_p()));
    }

    public boolean isTagsEqual(@Nullable FuzzyStack other) {
        return other != null && other.stripTags(this.getTagCompound()).equals((Object)this.stripTags(other.getTagCompound()));
    }

    public boolean isItemEqual(@Nullable Item other) {
        return other != null && this.stack.func_77973_b().equals(other);
    }

    public boolean isItemEqual(@Nullable ItemStack other) {
        return other != null && this.stack.func_77973_b().equals(other.func_77973_b());
    }

    public boolean isItemEqual(@Nullable FuzzyStack other) {
        return other != null && this.stack.func_77973_b().equals(other.stack.func_77973_b());
    }

    @Nonnull
    private NBTTagCompound stripTags(@Nullable NBTTagCompound tag) {
        if (tag == null || this.ignoreTags.contains("*")) {
            return new NBTTagCompound();
        }
        NBTTagCompound stripped = tag.func_74737_b();
        this.ignoreTags.forEach(arg_0 -> ((NBTTagCompound)stripped).func_82580_o(arg_0));
        return stripped;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack other = (ItemStack)obj;
            if (other.func_77973_b() != null) {
                return this.equals(new FuzzyStack(other));
            }
            return false;
        }
        if (obj instanceof FuzzyStack) {
            FuzzyStack other = (FuzzyStack)obj;
            if (this.isItemEqual(other) && this.isMetaEqual(other) && this.isTagsEqual(other)) {
                return true;
            }
            if (this.useOreDict || other.useOreDict) {
                ItemStack a = this.toStack();
                ItemStack b = other.toStack();
                int[] ids1 = a.func_190926_b() ? new int[]{} : OreDictionary.getOreIDs((ItemStack)a);
                int[] ids2 = b.func_190926_b() ? new int[]{} : OreDictionary.getOreIDs((ItemStack)b);
                for (int id1 : ids1) {
                    for (int id2 : ids2) {
                        if (id1 != id2) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.stack);
        hash = 97 * hash + Objects.hashCode(this.tags);
        hash = 97 * hash + (this.ignoreMeta ? 1 : 0);
        hash = 97 * hash + (this.useOreDict ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.ignoreTags);
        return hash;
    }

    public String toString() {
        return this.stack.toString();
    }
}

