/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.core;

import com.agricraft.agricore.config.AgriConfig;
import com.agricraft.agricore.config.AgriConfigAdapter;
import com.agricraft.agricore.defaults.AgriDefaultConfig;
import com.agricraft.agricore.defaults.AgriDefaultConverter;
import com.agricraft.agricore.defaults.AgriDefaultLog;
import com.agricraft.agricore.defaults.AgriDefaultTranslator;
import com.agricraft.agricore.defaults.AgriDefaultValidator;
import com.agricraft.agricore.lang.AgriTranslationAdapter;
import com.agricraft.agricore.lang.AgriTranslator;
import com.agricraft.agricore.log.AgriLogAdapter;
import com.agricraft.agricore.log.AgriLogManager;
import com.agricraft.agricore.log.AgriLogger;
import com.agricraft.agricore.registry.AgriMutations;
import com.agricraft.agricore.registry.AgriPlants;
import com.agricraft.agricore.registry.AgriSoils;
import com.agricraft.agricore.util.AgriConverter;
import com.agricraft.agricore.util.AgriValidator;

public final class AgriCore {
    private static AgriLogManager logManager = new AgriLogManager(new AgriDefaultLog());
    private static AgriTranslator translator = new AgriTranslator(new AgriDefaultTranslator());
    private static AgriValidator validator;
    private static AgriConverter converter;
    private static AgriConfig config;
    private static AgriPlants plants;
    private static AgriMutations mutations;
    private static AgriSoils soils;

    private AgriCore() {
    }

    public static void init(AgriLogAdapter log, AgriTranslationAdapter trans, AgriValidator validator, AgriConverter converter, AgriConfigAdapter provider) {
        logManager = new AgriLogManager(log);
        translator = new AgriTranslator(trans);
        config = new AgriConfig(provider);
        AgriLogger logger = AgriCore.getCoreLogger();
        logger.info("Initializing core!", new Object[0]);
        AgriCore.validator = validator;
        AgriCore.converter = converter;
        plants = new AgriPlants();
        mutations = new AgriMutations();
        soils = new AgriSoils();
        logger.info("Loading config!", new Object[0]);
        config.load();
        logger.info("Loaded config!", new Object[0]);
        logger.info("Configuring modules!", new Object[0]);
        config.addConfigurable(logger);
        config.addConfigurable(validator);
        config.addConfigurable(plants);
        config.addConfigurable(mutations);
        config.addConfigurable(soils);
        logger.info("Configured modules!", new Object[0]);
        logger.info("Saving config!", new Object[0]);
        config.save();
        logger.info("Saved config!", new Object[0]);
        logger.info("Initialized core!", new Object[0]);
    }

    public static AgriLogger getCoreLogger() {
        return AgriCore.getLogger("agricore");
    }

    public static AgriLogger getLogger(Object source) {
        return logManager.getLogger(source);
    }

    public static AgriTranslator getTranslator() {
        return translator;
    }

    public static AgriLogManager getLogManager() {
        return logManager;
    }

    public static AgriValidator getValidator() {
        return validator;
    }

    public static AgriConverter getConverter() {
        return converter;
    }

    public static AgriConfig getConfig() {
        return config;
    }

    public static AgriMutations getMutations() {
        return mutations;
    }

    public static AgriPlants getPlants() {
        return plants;
    }

    public static AgriSoils getSoils() {
        return soils;
    }

    static {
        config = new AgriConfig(new AgriDefaultConfig());
        validator = new AgriDefaultValidator();
        converter = new AgriDefaultConverter();
        plants = new AgriPlants();
        mutations = new AgriMutations();
        soils = new AgriSoils();
    }
}

