/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.tile_entities;

import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.enchantments.AetherEnchantment;
import com.gildedgames.the_aether.api.events.AetherHooks;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.container.BlockAetherContainer;
import com.gildedgames.the_aether.tile_entities.util.AetherTileEntity;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEnchanter
extends AetherTileEntity {
    public int progress;
    public int ticksRequired;
    public int powerRemaining;
    private NonNullList<ItemStack> enchantedItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private AetherEnchantment currentEnchantment;

    public TileEntityEnchanter() {
        super("enchanter");
    }

    @Override
    public NonNullList<ItemStack> getTileInventory() {
        return this.enchantedItemStacks;
    }

    @Override
    public void onSlotChanged(int index) {
    }

    public void func_73660_a() {
        boolean flag = this.isEnchanting();
        if (this.powerRemaining > 0) {
            --this.powerRemaining;
            if (this.currentEnchantment != null && !this.currentEnchantment.getOutput().func_190926_b()) {
                this.progress = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() == BlocksAether.enchanted_gravitite ? (int)((float)this.progress + 2.5f) : ++this.progress;
            }
        }
        if (this.currentEnchantment != null) {
            if (!this.currentEnchantment.getOutput().func_190926_b()) {
                if (this.progress >= this.ticksRequired) {
                    if (!this.field_145850_b.field_72995_K) {
                        ItemStack result = this.currentEnchantment.getOutput().func_77946_l();
                        EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)this.func_70301_a(0)), (ItemStack)result);
                        if (this.func_70301_a(0).func_77942_o()) {
                            result.func_77982_d(this.func_70301_a(0).func_77978_p());
                        }
                        if (!this.func_70301_a(2).func_190926_b() && this.func_70301_a(2).func_77985_e()) {
                            result.func_190920_e(this.func_70301_a(2).func_190916_E() + 1);
                            this.func_70299_a(2, result);
                        } else {
                            this.func_70299_a(2, result);
                        }
                        if (this.func_70301_a(0).func_77973_b().hasContainerItem(this.func_70301_a(0))) {
                            this.func_70299_a(0, this.func_70301_a(0).func_77973_b().getContainerItem(this.func_70301_a(0)));
                        } else {
                            this.func_70298_a(0, 1);
                        }
                    }
                    this.progress = 0;
                    AetherHooks.onItemEnchant(this, this.currentEnchantment);
                }
                if (this.func_70301_a(0).func_190926_b() || !this.func_70301_a(0).func_190926_b() && AetherAPI.getInstance().getEnchantment(this.func_70301_a(0)) != this.currentEnchantment) {
                    this.currentEnchantment = null;
                    this.progress = 0;
                }
                if (this.powerRemaining <= 0) {
                    if (!this.func_70301_a(1).func_190926_b() && AetherAPI.getInstance().isEnchantmentFuel(this.func_70301_a(1))) {
                        this.powerRemaining += AetherAPI.getInstance().getEnchantmentFuel(this.func_70301_a(1)).getTimeGiven();
                        if (!this.field_145850_b.field_72995_K) {
                            this.func_70298_a(1, 1);
                        }
                    } else {
                        this.currentEnchantment = null;
                        this.progress = 0;
                    }
                }
            } else {
                this.currentEnchantment = null;
            }
        } else if (!this.func_70301_a(0).func_190926_b()) {
            ItemStack itemstack = this.func_70301_a(0);
            AetherEnchantment enchantment = AetherAPI.getInstance().getEnchantment(itemstack);
            if (enchantment != null && (this.func_70301_a(2).func_190926_b() || enchantment.getOutput().func_77973_b() == this.func_70301_a(2).func_77973_b() && enchantment.getOutput().func_77960_j() == this.func_70301_a(2).func_77960_j() && this.func_70301_a(2).func_77985_e())) {
                this.currentEnchantment = enchantment;
                this.ticksRequired = this.currentEnchantment.getTimeRequired();
                this.addEnchantmentWeight(itemstack);
                this.ticksRequired = AetherHooks.onSetEnchantmentTime(this, this.currentEnchantment, this.ticksRequired);
            }
        }
        if (flag != this.isEnchanting()) {
            this.func_70296_d();
            BlockAetherContainer.setState(this.field_145850_b, this.field_174879_c, this.isEnchanting());
        }
    }

    public void addEnchantmentWeight(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (!enchantments.isEmpty()) {
            Iterator iterator = enchantments.values().iterator();
            while (iterator.hasNext()) {
                int levels = (Integer)iterator.next();
                this.ticksRequired += levels * 1250;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentProgressScaled(int i) {
        if (this.ticksRequired == 0) {
            return 0;
        }
        return this.progress * i / this.ticksRequired;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentTimeRemaining(int i) {
        return this.powerRemaining * i / 500;
    }

    public boolean isEnchanting() {
        return this.powerRemaining > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.progress = compound.func_74762_e("progress");
        this.powerRemaining = compound.func_74762_e("powerRemaining");
        this.ticksRequired = compound.func_74762_e("ticksRequired");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("progress", this.progress);
        compound.func_74768_a("powerRemaining", this.powerRemaining);
        compound.func_74768_a("ticksRequired", this.ticksRequired);
        return super.func_189515_b(compound);
    }

    @Override
    public boolean isValidSlotItem(int slot, ItemStack stackInSlot) {
        if (slot == 2) {
            return false;
        }
        if (slot == 1 && AetherAPI.getInstance().isEnchantmentFuel(stackInSlot)) {
            return true;
        }
        return slot == 0 && AetherAPI.getInstance().hasEnchantment(stackInSlot);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        return nArray;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.progress;
        }
        if (id == 1) {
            return this.powerRemaining;
        }
        if (id == 2) {
            return this.ticksRequired;
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.progress = value;
        } else if (id == 1) {
            this.powerRemaining = value;
        } else if (id == 2) {
            this.ticksRequired = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }
}

