/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.blocks.portal;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.blocks.portal.AetherPortalSize;
import com.gildedgames.the_aether.entities.particles.ParticleAetherPortal;
import com.gildedgames.the_aether.registry.sounds.SoundsAether;
import com.gildedgames.the_aether.world.TeleporterAether;
import com.google.common.cache.LoadingCache;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAetherPortal
extends BlockPortal {
    public BlockAetherPortal() {
        this.func_149711_c(-1.0f);
        this.func_149752_b(900000.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int transferDimension;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        int previousDimension = entity.field_71093_bK;
        int n = transferDimension = previousDimension == AetherConfig.dimension.aether_dimension_id ? 0 : AetherConfig.dimension.aether_dimension_id;
        if (entity instanceof EntityPlayer && !entity.func_184218_aH()) {
            AetherAPI.getInstance().get((EntityPlayer)entity).setInPortal();
        } else if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = entity.func_82147_ab();
            } else if (!world.field_72995_K) {
                entity.field_71088_bW = 300;
                entity.changeDimension(transferDimension, (ITeleporter)new TeleporterAether(true, server.func_71218_a(transferDimension)));
            }
        }
    }

    public boolean func_176548_d(World worldIn, BlockPos pos) {
        if (AetherConfig.gameplay_changes.disable_portal) {
            return false;
        }
        AetherPortalSize aetherportal$size = new AetherPortalSize(worldIn, pos, EnumFacing.Axis.X);
        if (aetherportal$size.isValid() && aetherportal$size.portalBlockCount == 0) {
            aetherportal$size.placePortalBlocks();
            return true;
        }
        AetherPortalSize aetherportal$size1 = new AetherPortalSize(worldIn, pos, EnumFacing.Axis.Z);
        if (aetherportal$size1.isValid() && aetherportal$size1.portalBlockCount == 0) {
            aetherportal$size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        AetherPortalSize blockportal$size1;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            AetherPortalSize blockportal$size = new AetherPortalSize(worldIn, pos, EnumFacing.Axis.X);
            if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (!(enumfacing$axis != EnumFacing.Axis.Z || (blockportal$size1 = new AetherPortalSize(worldIn, pos, EnumFacing.Axis.Z)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsAether.aether_portal_idling, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            ParticleAetherPortal particle = new ParticleAetherPortal(world, d0, d1, d2, d3, d4, d5);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    public BlockPattern.PatternHelper func_181089_f(World worldIn, BlockPos p_181089_2_) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Z;
        AetherPortalSize blockportal$size = new AetherPortalSize(worldIn, p_181089_2_, EnumFacing.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((World)worldIn, (boolean)true);
        if (!blockportal$size.isValid()) {
            enumfacing$axis = EnumFacing.Axis.X;
            blockportal$size = new AetherPortalSize(worldIn, p_181089_2_, EnumFacing.Axis.Z);
        }
        if (!blockportal$size.isValid()) {
            return new BlockPattern.PatternHelper(p_181089_2_, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = blockportal$size.rightDir.func_176735_f();
        BlockPos blockpos = blockportal$size.bottomLeft.func_177981_b(blockportal$size.getHeight() - 1);
        for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
            for (int i = 0; i < blockportal$size.getWidth(); ++i) {
                for (int j = 0; j < blockportal$size.getHeight(); ++j) {
                    BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (blockworldstate.func_177509_a() == null || blockworldstate.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = enumfacing$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
    }
}

