/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;

public final class EnumMatcher
extends AbstractMatcher<EnumMatcher> {
    private MatcherEnum matcherEnum;

    public EnumMatcher(@Nonnull AbstractMatching<?> matching) {
        this(matching, MatcherEnum.DISABLED);
    }

    public EnumMatcher(@Nonnull AbstractMatching<?> matching, @Nonnull MatcherEnum matcherEnum) {
        super(matching);
        this.matcherEnum = matcherEnum;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound matchingNbt = super.writeNBT();
        if (this.matcherEnum != MatcherEnum.DISABLED) {
            matchingNbt.func_74778_a("enum", this.matcherEnum.lowerCaseName);
        }
        return matchingNbt;
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.matcherEnum = nbtTagCompound.func_74764_b("enum") ? MatcherEnum.getMatcherEnumByName(nbtTagCompound.func_74779_i("enum")) : MatcherEnum.DISABLED;
    }

    @Override
    @Nonnull
    public EnumMatcher copy() {
        return new EnumMatcher(this.matching, this.matcherEnum);
    }

    @Override
    @Nonnull
    public MatcherEnum getMatcherEnum() {
        return MatcherEnum.ENUM;
    }

    @Override
    @Nonnull
    public AbstractMatcher<?> validate() {
        return this;
    }

    @Override
    public boolean matches(@Nonnull ItemStack otherItemStack) {
        return this.matcherEnum.accepts(otherItemStack);
    }
}

