/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.control.energy;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import wanion.lib.common.control.IControl;

public class EnergyControl
implements IEnergyStorage,
IControl<EnergyControl> {
    private final int capacity;
    private int energyUsage;
    private int energy;

    public EnergyControl(int capacity, int energyUsage) {
        this(capacity, energyUsage, 0);
    }

    public EnergyControl(int capacity, int energyUsage, int energy) {
        this.capacity = capacity;
        this.energyUsage = energyUsage;
        this.energy = energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.capacity, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyUsage() {
        return this.energyUsage;
    }

    public void setEnergyUsage(int energyUsage) {
        this.energyUsage = energyUsage;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    private void useEnergy(int energy) {
        this.energy -= energy;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    @Override
    public boolean canOperate() {
        return this.getEnergyStored() >= this.energyUsage;
    }

    @Override
    public void operate() {
        this.useEnergy(this.energyUsage);
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a("Energy", this.energy);
        return nbtTagCompound;
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("Energy")) {
            this.setEnergyStored(nbtTagCompound.func_74762_e("Energy"));
        }
    }

    @Override
    @Nonnull
    public EnergyControl copy() {
        return new EnergyControl(this.capacity, this.energyUsage, this.energy);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EnergyControl && this.energy == ((EnergyControl)obj).energy;
    }
}

