/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.proxy;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.item.map.IMapRenderer;
import codechicken.lib.render.item.map.MapRenderRegistry;
import codechicken.lib.texture.TextureUtils;
import codechicken.wirelessredstone.api.ITileWireless;
import codechicken.wirelessredstone.client.gui.GuiPrivateSniffer;
import codechicken.wirelessredstone.client.gui.GuiRedstoneWireless;
import codechicken.wirelessredstone.client.gui.GuiWirelessSniffer;
import codechicken.wirelessredstone.client.render.RenderTracker;
import codechicken.wirelessredstone.client.render.RenderWireless;
import codechicken.wirelessredstone.client.render.WirelessMapRenderer;
import codechicken.wirelessredstone.client.render.item.RenderItemTracker;
import codechicken.wirelessredstone.client.render.item.RenderItemWireless;
import codechicken.wirelessredstone.client.texture.RemoteTexManager;
import codechicken.wirelessredstone.client.texture.TriangTexManager;
import codechicken.wirelessredstone.entity.EntityREP;
import codechicken.wirelessredstone.entity.EntityWirelessTracker;
import codechicken.wirelessredstone.init.ModItems;
import codechicken.wirelessredstone.item.ItemWirelessRemote;
import codechicken.wirelessredstone.manager.SaveManager;
import codechicken.wirelessredstone.network.WRClientPH;
import codechicken.wirelessredstone.proxy.Proxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ProxyClient
extends Proxy {
    @Override
    public void preInit() {
        super.preInit();
        GuiWirelessSniffer.loadColours(SaveManager.config().getTag("addon"));
        TextureUtils.addIconRegister((TextureUtils.IIconRegister)new RenderWireless());
        TextureUtils.addIconRegister((TextureUtils.IIconRegister)new RemoteTexManager());
        TextureUtils.addIconRegister((TextureUtils.IIconRegister)new TriangTexManager());
        PacketCustom.assignHandler((Object)"WRCBE", (ICustomPacketHandler)new WRClientPH());
        MapRenderRegistry.registerMapRenderer((Item)ModItems.itemWirelessMap, (IMapRenderer)new WirelessMapRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityREP.class, manager -> new RenderSnowball(manager, (Item)ModItems.itemRep, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityWirelessTracker.class, RenderTracker::new);
        this.registerModels();
    }

    private void registerModels() {
        ModelRegistryHelper.registerItemRenderer((Item)ModItems.itemWireless, (IItemRenderer)new RenderItemWireless());
        ModItems.itemMaterial.registerModels();
        ModelResourceLocation location = new ModelResourceLocation("wrcbe:material", "type=rep");
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.itemRep, (int)0, (ModelResourceLocation)location);
        ModelLoader.setCustomMeshDefinition((Item)ModItems.itemRemote, stack -> new ModelResourceLocation("wrcbe:device", "type=wireless_remote"));
        ModelLoader.registerItemVariants((Item)ModItems.itemRemote, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("wrcbe:device", "type=wireless_remote")});
        ModelBakery.registerItemKeyGenerator((Item)ModItems.itemRemote, stack -> stack.func_77973_b().getRegistryName().toString() + "|" + stack.func_77960_j() + "," + ItemWirelessRemote.getTransmitting(stack));
        ModelLoader.setCustomMeshDefinition((Item)ModItems.itemTriangulator, stack -> new ModelResourceLocation("wrcbe:device", "type=wireless_triangulator"));
        ModelLoader.registerItemVariants((Item)ModItems.itemTriangulator, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("wrcbe:device", "type=wireless_triangulator")});
        ModelBakery.registerItemKeyGenerator((Item)ModItems.itemTriangulator, stack -> {
            int damage = stack.func_77952_i();
            if (damage < 0 || damage > 5000) {
                damage = 0;
            }
            TriangTexManager.getIconIndexFromDamage(damage);
            return ModelBakery.defaultItemKeyGenerator.generateKey(stack);
        });
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.itemSniffer, (int)0, (ModelResourceLocation)new ModelResourceLocation("wrcbe:device", "type=sniffer"));
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.itemPrivateSniffer, (int)0, (ModelResourceLocation)new ModelResourceLocation("wrcbe:device", "type=private_sniffer"));
        ModelRegistryHelper.registerItemRenderer((Item)ModItems.itemTracker, (IItemRenderer)new RenderItemTracker());
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.itemEmptyWirelessMap, (int)0, (ModelResourceLocation)new ModelResourceLocation("wrcbe:device", "type=empty_wireless_map"));
        ModelLoader.registerItemVariants((Item)ModItems.itemWirelessMap, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("wrcbe:device", "type=wireless_map")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.itemWirelessMap, stack -> new ModelResourceLocation("wrcbe:device", "type=wireless_map"));
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public void openItemWirelessGui(EntityPlayer entityplayer) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRedstoneWireless(entityplayer.field_71071_by));
    }

    @Override
    public void openTileWirelessGui(EntityPlayer entityplayer, ITileWireless tile) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRedstoneWireless(entityplayer.field_71071_by, tile));
    }

    @Override
    public void openSnifferGui(EntityPlayer player) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWirelessSniffer());
    }

    @Override
    public void openPSnifferGui(EntityPlayer player) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPrivateSniffer());
    }
}

