/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world;

import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.api.UndergroundBiomeSet;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.api.event.UBForceReProcessEvent;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.world.TraditionalStoneReplacer;
import exterminatorjeff.undergroundbiomes.world.UBBiomesSet;
import exterminatorjeff.undergroundbiomes.world.UBStoneReplacer;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public final class WorldGenManager
implements UBStrataColumnProvider {
    private final UBLogger LOGGER;
    private final int dimensionID;
    private final UndergroundBiomeSet biomesSet;
    private UBStoneReplacer stoneReplacer;
    private boolean worldLoaded = false;
    private final CopyOnWriteArrayList<ChunkUpdate> chunkUpdates = new CopyOnWriteArrayList();

    public WorldGenManager(int dimensionID) {
        this.LOGGER = new UBLogger(WorldGenManager.class + " " + dimensionID, Level.INFO);
        this.LOGGER.debug("Dimension " + dimensionID + " will be UBified");
        this.dimensionID = dimensionID;
        this.biomesSet = new UBBiomesSet(UBConfig.SPECIFIC);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == this.dimensionID && !this.worldLoaded) {
            this.LOGGER.debug("Dimension " + this.dimensionID + " loaded");
            this.worldLoaded = true;
            world.func_72860_G().func_75765_b();
            int seed = (int)world.func_72905_C();
            if (UBConfig.SPECIFIC.dimensionSpecificSeeds()) {
                seed += this.dimensionID;
            }
            this.stoneReplacer = new TraditionalStoneReplacer(seed, UBConfig.SPECIFIC.biomeSize(), this.biomesSet);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            this.worldLoaded = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        this.onProcess(event.getWorld(), event.getChunkX(), event.getChunkZ());
    }

    @SubscribeEvent
    public void onForceReprocessAll(UBForceReProcessEvent event) {
        this.onProcess(event.getWorld(), event.getChunkX(), event.getChunkZ());
    }

    public void onProcess(World world, int chunkX, int chunkZ) {
        if (world.field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            this.doProcess(world, chunkX, chunkZ, false);
            this.chunkUpdates.add(new ChunkUpdate(chunkX, chunkZ));
        }
    }

    public void doProcess(World world, int chunkX, int chunkZ, boolean sendUpdates) {
        if (world.field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            Chunk chunk = world.func_72964_e(chunkX, chunkZ);
            this.stoneReplacer.replaceStoneInChunk(world, chunk, sendUpdates);
            this.stoneReplacer.redoOres(world);
        }
    }

    public void onTick() {
        if (this.chunkUpdates.isEmpty()) {
            return;
        }
        WorldServer world = DimensionManager.getWorld((int)this.dimensionID);
        if (world == null) {
            return;
        }
        for (ChunkUpdate chunkUpdate : this.chunkUpdates) {
            --chunkUpdate.tick;
            if (chunkUpdate.tick > 0L) continue;
            this.doProcess((World)world, chunkUpdate.chunkX, chunkUpdate.chunkZ, true);
            this.chunkUpdates.remove(chunkUpdate);
        }
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        if (event.getWorld().field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            switch (event.getType()) {
                case GRANITE: 
                case DIORITE: 
                case ANDESITE: {
                    event.setResult(Event.Result.DENY);
                    break;
                }
            }
        }
    }

    @Override
    public UBStrataColumn strataColumn(int x, int z) {
        return this.stoneReplacer.strataColumn(x, z);
    }

    private static class ChunkUpdate {
        public long tick = 2L;
        public final int chunkX;
        public final int chunkZ;

        public ChunkUpdate(int chunkX, int chunkZ) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }
    }
}

