/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.core;

import exterminatorjeff.undergroundbiomes.api.UBDimensionalStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.core.UndergroundBiomes;
import exterminatorjeff.undergroundbiomes.world.WorldGenManager;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class DimensionManager
implements UBDimensionalStrataColumnProvider {
    public HashMap<Integer, WorldGenManager> managers = new HashMap();
    private boolean villageRegistered = false;
    private boolean oreRegistered = false;
    private final UBStrataColumnProvider vanillaColumnProvider = new UBStrataColumnProvider(){

        @Override
        public UBStrataColumn strataColumn(int x, int z) {
            return DimensionManager.this.vanillaColumn;
        }
    };
    private final UBStrataColumn vanillaColumn = new UBStrataColumn(){

        @Override
        public IBlockState stone(int height) {
            return Blocks.field_150348_b.func_176223_P();
        }

        @Override
        public IBlockState cobblestone(int height) {
            return Blocks.field_150347_e.func_176223_P();
        }

        @Override
        public IBlockState stone() {
            return Blocks.field_150348_b.func_176223_P();
        }

        @Override
        public IBlockState cobblestone() {
            return Blocks.field_150347_e.func_176223_P();
        }
    };

    public void refreshManagers() {
        if (UBConfig.SPECIFIC.ubifyVillages() && !this.villageRegistered) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
            this.villageRegistered = true;
        }
        if (!UBConfig.SPECIFIC.ubifyVillages() && this.villageRegistered) {
            MinecraftForge.TERRAIN_GEN_BUS.unregister((Object)this);
            this.villageRegistered = false;
        }
        if (UBConfig.SPECIFIC.disableVanillaStoneVariants() && !this.oreRegistered) {
            MinecraftForge.ORE_GEN_BUS.register((Object)this);
            this.oreRegistered = true;
        }
        if (!UBConfig.SPECIFIC.disableVanillaStoneVariants() && this.oreRegistered) {
            MinecraftForge.ORE_GEN_BUS.unregister((Object)this);
            this.oreRegistered = false;
        }
        for (WorldGenManager manager : this.managers.values()) {
            if (manager == null) continue;
            MinecraftForge.EVENT_BUS.unregister((Object)manager);
        }
        this.managers = new HashMap();
        ((UBConfig)UBConfig.SPECIFIC).getUBifiedDimensions().forEach(dimensionID -> {
            WorldGenManager manager = new WorldGenManager((int)dimensionID);
            MinecraftForge.EVENT_BUS.register((Object)manager);
            this.managers.put((Integer)dimensionID, manager);
        });
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        int dimension;
        WorldGenManager target;
        if (this.managers.size() == 0) {
            UndergroundBiomes.PROXY.onServerLoad(event.getWorld().func_73046_m());
        }
        if ((target = this.managers.get(dimension = event.getWorld().field_73011_w.getDimension())) != null) {
            target.onWorldLoad(event);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        for (WorldGenManager target : this.managers.values()) {
            if (target == null) continue;
            target.onTick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        int dimension = event.getWorld().field_73011_w.getDimension();
        WorldGenManager target = this.managers.get(dimension);
        if (target != null) {
            target.onGenerateMinable(event);
        }
    }

    public void clear() {
        this.managers.clear();
    }

    @Override
    public UBStrataColumnProvider ubStrataColumnProvider(int dimension) {
        WorldGenManager manager = this.managers.get(dimension);
        if (manager == null) {
            return this.vanillaColumnProvider;
        }
        return manager;
    }
}

