/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.config.data.DistanceData;
import com.bloodnbonesgaming.triumph.config.data.EntityPredicateExtended;
import com.bloodnbonesgaming.triumph.config.data.LocationData;
import com.bloodnbonesgaming.triumph.config.data.LocationPredicateExtended;
import com.bloodnbonesgaming.triumph.config.data.ScoreBoardPredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/dataObjects/EntityData", classExplaination="These are the functions which can be called on an EntityData object.")
public class EntityData {
    protected ResourceLocation entityType;
    protected final DistanceData distance = new DistanceData();
    protected final LocationData locationData = new LocationData();
    protected ScoreBoardPredicate scoreboard = ScoreBoardPredicate.ANY;
    protected String name = null;

    public EntityPredicate buildPredicate() throws Exception {
        DistancePredicate distance = this.distance.buildDistancePredicate();
        LocationPredicateExtended location = this.locationData.buildLocationPredicate();
        if (this.entityType == null && distance == DistancePredicate.field_193423_a && location == LocationPredicateExtended.ANY && this.scoreboard == ScoreBoardPredicate.ANY && this.name == null) {
            return EntityPredicateExtended.ANY;
        }
        return new EntityPredicateExtended(this.entityType, distance, this.locationData.buildLocationPredicate(), MobEffectsPredicate.field_193473_a, NBTPredicate.field_193479_a, this.scoreboard, this.name);
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the entity type.")
    public void setType(String type) {
        ResourceLocation location = new ResourceLocation(type);
        if (EntityList.func_180125_b((ResourceLocation)location)) {
            this.entityType = location;
        } else {
            Triumph.instance.getLog().error((Object)(type + " is not a valid Entity type."));
        }
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the DistanceData object so functions can be called on it.")
    public DistanceData getDistanceData() {
        return this.distance;
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object so functions can be called on it.")
    public LocationData getLocationData() {
        return this.locationData;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id. Can be an int or String.")
    public void setBiome(int id) {
        this.locationData.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id. Used for things like structures.")
    public void setFeature(String feature) {
        this.locationData.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="String", usage="dimension type", notes="Sets the dimension type. Vanilla options are \"overworld\", \"the_nether\", \"the_end\"")
    public void setDimensionType(String type) {
        this.locationData.setDimensionType(type);
    }

    @ScriptMethodDocumentation(args="int", usage="dimension id", notes="Sets the dimension id.")
    public void setDimID(int dimID) {
        this.locationData.setDimID(dimID);
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType id", notes="Sets the WorldType id.")
    public void setWorldType(String worldType) {
        this.locationData.setWorldType(worldType);
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the generator options string.")
    public void setGeneratorOptions(String generatorOptions) {
        this.locationData.setGeneratorOptions(generatorOptions);
    }

    @ScriptMethodDocumentation(args="String, Float, Float", usage="score name, min score, max score", notes="Sets a required scoreboard score.")
    public void setScoreboard(String name, Float minScore, Float maxScore) {
        this.scoreboard = new ScoreBoardPredicate(name, new MinMaxBounds(minScore, maxScore));
    }

    @ScriptMethodDocumentation(args="String", usage="name", notes="Sets the required name for the entity.")
    public void setName(String name) {
        this.name = name;
    }
}

