/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.config.data.DamageSourcePredicateExtended;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import net.minecraft.advancements.critereon.DamageSourcePredicate;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/dataObjects/DamageSourceData", classExplaination="These are the functions which can be called on a DamageSourceData object.")
public class DamageSourceData {
    private Boolean isProjectile;
    private Boolean isExplosion;
    private Boolean bypassesArmor;
    private Boolean bypassesInvulnerability;
    private Boolean bypassesMagic;
    private Boolean isFire;
    private Boolean isMagic;
    private final EntityData immediateSourceData = new EntityData();
    private final EntityData sourceData = new EntityData();
    private String damageType;

    public DamageSourcePredicate buildPredicate() throws Exception {
        return new DamageSourcePredicateExtended(this.isProjectile, this.isExplosion, this.bypassesArmor, this.bypassesInvulnerability, this.bypassesMagic, this.isFire, this.isMagic, this.immediateSourceData.buildPredicate(), this.sourceData.buildPredicate(), this.damageType);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the immediate source entity (This would be for things like projectiles.) so functions can be called on it.")
    public EntityData getImmediateSourceData() {
        return this.immediateSourceData;
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the source entity (This would be for the player/skeleton/etc.) so functions can be called on it.")
    public EntityData getSourceData() {
        return this.sourceData;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is a projectile.")
    public void isProjectile(boolean bool) {
        this.isProjectile = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is an explosion.")
    public void isExplosion(boolean bool) {
        this.isExplosion = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source bypasses armor.")
    public void bypassesArmor(boolean bool) {
        this.bypassesArmor = true;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source bypasses invulerability.")
    public void bypassesInvulnerability(boolean bool) {
        this.bypassesInvulnerability = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source bypasses magic.")
    public void bypassesMagic(boolean bool) {
        this.bypassesMagic = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is fire.")
    public void isFire(boolean bool) {
        this.isFire = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is magic.")
    public void isMagic(boolean bool) {
        this.isMagic = bool;
    }

    @ScriptMethodDocumentation(args="String", usage="damage type", notes="Sets the damage type string used to construct the DamageSource. Vanilla examples include \"inFire\", \"outOfWorld\", \"cactus\", \"drown\", \"starve\"")
    public void damageType(String type) {
        this.damageType = type;
    }
}

