/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.RightClickItemTrigger;
import com.bloodnbonesgaming.triumph.config.data.LocationData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/triumph/right_click_item", classExplaination="These are the functions which can be called on a triumph:right_click_item criteria trigger. This criteria is triggered by a player right clicking with an item.")
public class RightClickItemTriggerData
extends CriterionTriggerData {
    ItemPredicate itemPredicate = ItemPredicate.field_192495_a;
    private final LocationData locationData = new LocationData();

    public RightClickItemTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        return new Criterion((ICriterionInstance)new RightClickItemTrigger.Instance(this.itemPredicate, this.locationData.buildLocationPredicate()));
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the required item.")
    public void setItem(ItemBlockData data) throws Exception {
        this.itemPredicate = data.buildItemPredicate();
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object so functions can be called on it.")
    public LocationData getLocationData() {
        return this.locationData;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id. Can be an int or String.")
    public void setBiome(int id) {
        this.locationData.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id. Used for things like structures.")
    public void setFeature(String feature) {
        this.locationData.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="int", usage="dimension id", notes="Sets the dimension id.")
    public void setDimID(int dimID) {
        this.locationData.setDimID(dimID);
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType id", notes="Sets the WorldType id.")
    public void setWorldType(String worldType) {
        this.locationData.setWorldType(worldType);
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the generator options string.")
    public void setGeneratorOptions(String generatorOptions) {
        this.locationData.setGeneratorOptions(generatorOptions);
    }
}

