/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data.totemic;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.util.ResourceLocation;
import pokefenn.totemic.advancements.criterion.CeremonyTrigger;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.ceremony.Ceremony;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/totemic/perform_ceremony", classExplaination="These are the functions which can be called on a totemic:perform_ceremony criteria trigger. This criteria is triggered by a player performing a ceremony.")
public class CeremonyTriggerData
extends CriterionTriggerData {
    private Ceremony ceremony;

    public CeremonyTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        if (this.ceremony == null) {
            throw new Exception("The 'totemic:perform_ceremony' trigger must have a ceremony set.");
        }
        return new Criterion((ICriterionInstance)new CeremonyTrigger.Instance(this.ceremony));
    }

    @ScriptMethodDocumentation(args="String", usage="ceremony id", notes="Sets the ceremony that the player must perform to complete the criteria.")
    public void setCeremony(String string) throws Exception {
        Ceremony ceremony = (Ceremony)TotemicRegistries.ceremonies().getValue(new ResourceLocation(string));
        if (ceremony == null) {
            throw new Exception(string + " is not a valid Totemic ceremony.");
        }
        this.ceremony = ceremony;
    }
}

