/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.MinMaxBoundsData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ItemDurabilityTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/item_durability_changed", classExplaination="These are the functions which can be called on a minecraft:item_durability_changed criteria trigger.")
public class ItemDurabilityTriggerData
extends CriterionTriggerData {
    ItemPredicate itemPredicate = ItemPredicate.field_192495_a;
    private ItemBlockData itemData = new ItemBlockData();
    private MinMaxBoundsData durability = new MinMaxBoundsData();
    private MinMaxBoundsData delta = new MinMaxBoundsData();

    public ItemDurabilityTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        ItemPredicate item = this.itemPredicate == ItemPredicate.field_192495_a ? this.itemData.buildItemPredicate() : this.itemPredicate;
        return new Criterion((ICriterionInstance)new ItemDurabilityTrigger.Instance(item, this.durability.buildBounds(), this.delta.buildBounds()));
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the required item.")
    public void setItem(ItemBlockData data) throws Exception {
        this.itemPredicate = data.buildItemPredicate();
    }

    public ItemBlockData getItemData() {
        return this.itemData;
    }

    public void setItem(String itemName) {
        this.setItem(itemName, null);
    }

    public void setItem(String itemName, Integer meta) {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public void setOreDict(String oreDict) throws Exception {
        this.itemData.setOre(oreDict);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max item durability.")
    public void setDurabilityMinMax(float min, float max) {
        this.durability.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min item durability.")
    public void setDurabilityMin(float min) {
        this.durability.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max item durability.")
    public void setDurabilityMax(float max) {
        this.durability.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max delta.")
    public void setDeltaMinMax(float min, float max) {
        this.delta.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min delta.")
    public void setDeltaMin(float min) {
        this.delta.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max delta.")
    public void setDeltaMax(float max) {
        this.delta.setMax(max);
    }
}

