/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/bred_animals", classExplaination="These are the functions which can be called on a minecraft:bred_animals criteria trigger.")
public class BredAnimalsTriggerData
extends CriterionTriggerData {
    private final EntityData parentData = new EntityData();
    private final EntityData partnerData = new EntityData();
    private final EntityData childData = new EntityData();

    public BredAnimalsTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        return new Criterion((ICriterionInstance)new BredAnimalsTrigger.Instance(this.parentData.buildPredicate(), this.partnerData.buildPredicate(), this.childData.buildPredicate()));
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the parent so functions can be called on it.")
    public EntityData getParentData() {
        return this.parentData;
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the parent entity type.")
    public void setParentType(String type) {
        this.parentData.setType(type);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the partner so functions can be called on it.")
    public EntityData getPartnerData() {
        return this.partnerData;
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the partner entity type.")
    public void setPartnerType(String type) {
        this.partnerData.setType(type);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the child so functions can be called on it.")
    public EntityData getChildData() {
        return this.childData;
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the child entity type.")
    public void setChildType(String type) {
        this.childData.setType(type);
    }
}

