/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.shadow.shootingstar;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import prospector.traverse.shadow.shootingstar.BlockCompound;
import prospector.traverse.shadow.shootingstar.ItemCompound;
import prospector.traverse.shadow.shootingstar.model.ModelCompound;
import prospector.traverse.shadow.shootingstar.model.ModelMethods;

public class ShootingStar {
    protected static List<ModelCompound> modelList = new ArrayList<ModelCompound>();
    protected static List<BlockCompound> blockList = new ArrayList<BlockCompound>();
    protected static List<ItemCompound> itemList = new ArrayList<ItemCompound>();

    public static void registerModel(ModelCompound modelCompound) {
        modelList.add(modelCompound);
    }

    public static void registerModels(String modid) {
        for (ModelCompound compound : modelList) {
            if (!compound.getModid().equals(modid)) continue;
            if (compound.isBlock()) {
                if (compound.getFileName().equals("shootingstar.undefinedfilename")) {
                    if (Item.func_150898_a((Block)compound.getBlock()) != Items.field_190931_a) {
                        ModelMethods.registerItemModel(compound.getItem(), compound.getMeta(), compound.getBlockStatePath(), compound.getInventoryVariant());
                    }
                    if (ShootingStar.shouldDoCustomVariant(compound)) {
                        ModelMethods.setBlockStateMapper(compound.getBlock(), compound.getBlockStatePath(), compound.getVariant());
                    } else {
                        ModelMethods.setBlockStateMapper(compound.getBlock(), compound.getBlockStatePath(), compound.getIgnoreProperties());
                    }
                } else {
                    if (Item.func_150898_a((Block)compound.getBlock()) != Items.field_190931_a) {
                        ModelMethods.registerItemModel(compound.getItem(), compound.getMeta(), compound.getFileName(), compound.getBlockStatePath(), compound.getInventoryVariant());
                    }
                    if (ShootingStar.shouldDoCustomVariant(compound)) {
                        ModelMethods.setBlockStateMapper(compound.getBlock(), compound.getFileName(), compound.getBlockStatePath(), compound.getVariant());
                    } else {
                        ModelMethods.setBlockStateMapper(compound.getBlock(), compound.getFileName(), compound.getBlockStatePath(), compound.getIgnoreProperties());
                    }
                }
            }
            if (!compound.isItem()) continue;
            if (compound.getFileName().equals("shootingstar.undefinedfilename")) {
                ModelMethods.registerItemModel(compound.getItem(), compound.getMeta(), compound.getBlockStatePath(), compound.getInventoryVariant());
                continue;
            }
            ModelMethods.registerItemModel(compound.getItem(), compound.getMeta(), compound.getFileName(), compound.getBlockStatePath(), compound.getInventoryVariant());
        }
    }

    private static boolean shouldDoCustomVariant(ModelCompound compound) {
        return !compound.getVariant().equals("shootingstar.undefinedvariant");
    }

    public static Block getBlock(String modid, String name) {
        for (BlockCompound compound : blockList) {
            if (!compound.getRegistryName().equals((Object)new ResourceLocation(modid, name))) continue;
            return compound.getBlock();
        }
        throw new InvalidParameterException("Block '" + modid + ":" + name + "' cannot be found in the Shooting Star registry");
    }

    public static void registerBlock(BlockCompound blockCompound) {
        blockList.add(blockCompound);
    }

    public static void registerItem(ItemCompound itemCompound) {
        itemList.add(itemCompound);
    }

    public static void registerBlocks(String modid, RegistryEvent.Register<Block> event) {
        for (BlockCompound compound : blockList) {
            if (!compound.getModid().equals(modid)) continue;
            event.getRegistry().register((IForgeRegistryEntry)compound.getBlock());
        }
    }

    public static void registerItems(String modid, RegistryEvent.Register<Item> event) {
        for (BlockCompound blockCompound : blockList) {
            if (!blockCompound.hasItemBlock() || !blockCompound.getModid().equals(modid)) continue;
            if (blockCompound.getItem() == null) {
                event.getRegistry().register(new ItemBlock(blockCompound.getBlock()).setRegistryName(blockCompound.getBlock().getRegistryName()));
                continue;
            }
            event.getRegistry().register((IForgeRegistryEntry)blockCompound.getItem());
        }
        for (ItemCompound itemCompound : itemList) {
            if (!itemCompound.getModid().equals(modid)) continue;
            event.getRegistry().register((IForgeRegistryEntry)itemCompound.getItem());
        }
    }
}

