/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.tileentity.totem;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.api.TotemicCapabilities;
import pokefenn.totemic.api.totem.TotemBase;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.handler.GameOverlay;
import pokefenn.totemic.lib.WoodVariant;
import pokefenn.totemic.tileentity.TileTotemic;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemPole;
import pokefenn.totemic.tileentity.totem.TotemState;

public class TileTotemBase
extends TileTotemic
implements TotemBase,
ITickable {
    private boolean firstTick = true;
    private WoodVariant woodType = WoodVariant.OAK;
    private TotemState state = new StateTotemEffect(this);
    private final List<TotemEffect> totemEffectList = new ArrayList<TotemEffect>(5);
    private final Multiset<TotemEffect> totemEffects = HashMultiset.create((int)5);
    private int commonTotemEffectInterval = Integer.MAX_VALUE;

    public void func_73660_a() {
        if (this.firstTick) {
            this.calculateTotemEffects();
            this.firstTick = false;
        }
        this.state.func_73660_a();
    }

    private void calculateTotemEffects() {
        TileEntity tile;
        this.totemEffectList.clear();
        this.totemEffects.clear();
        for (int i = 0; i < 5 && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i + 1))) instanceof TileTotemPole; ++i) {
            TotemEffect effect = ((TileTotemPole)tile).getEffect();
            this.totemEffectList.add(effect);
            if (effect == null) continue;
            this.totemEffects.add((Object)effect);
        }
        this.commonTotemEffectInterval = this.totemEffects.elementSet().stream().mapToInt(TotemEffect::getInterval).reduce(IntMath::gcd).orElse(Integer.MAX_VALUE);
    }

    public void onPoleChange() {
        this.calculateTotemEffects();
    }

    public TotemState getState() {
        return this.state;
    }

    void setState(TotemState state) {
        if (state != this.state) {
            this.state = state;
            if (this.field_145850_b != null) {
                this.markForUpdate();
                this.func_70296_d();
            }
        }
    }

    public WoodVariant getWoodType() {
        return this.woodType;
    }

    public void setWoodType(WoodVariant woodType) {
        this.woodType = woodType;
    }

    public Multiset<TotemEffect> getTotemEffectSet() {
        return this.totemEffects;
    }

    public int getCommonTotemEffectInterval() {
        return this.commonTotemEffectInterval;
    }

    @Override
    public int getTotemEffectMusic() {
        if (this.state instanceof StateTotemEffect) {
            return ((StateTotemEffect)this.state).getMusicAmount();
        }
        return 0;
    }

    @Override
    public int getPoleSize() {
        return this.totemEffectList.size();
    }

    @Override
    public int getRepetition(TotemEffect effect) {
        return this.totemEffects.count((Object)effect);
    }

    public void resetState() {
        this.setState(new StateTotemEffect(this));
    }

    @SideOnly(value=Side.CLIENT)
    public void setCeremonyOverlay() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= 64.0) {
            GameOverlay.setActiveTotem(this);
        } else if (GameOverlay.getActiveTotem() == this) {
            GameOverlay.setActiveTotem(null);
        }
    }

    public void onChunkUnload() {
        this.func_145843_s();
    }

    public boolean hasCapability(Capability<?> cap, @Nullable EnumFacing facing) {
        return cap == TotemicCapabilities.MUSIC_ACCEPTOR || super.hasCapability(cap, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> cap, @Nullable EnumFacing facing) {
        if (cap == TotemicCapabilities.MUSIC_ACCEPTOR) {
            return (T)TotemicCapabilities.MUSIC_ACCEPTOR.cast((Object)this.getState());
        }
        return (T)super.getCapability(cap, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74774_a("wood", (byte)this.woodType.getID());
        tag.func_74774_a("state", (byte)this.state.getID());
        this.state.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.woodType = WoodVariant.fromID(tag.func_74771_c("wood"));
        this.state = tag.func_150297_b("state", 99) ? TotemState.fromID(tag.func_74771_c("state"), this) : new StateTotemEffect(this);
        this.state.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

