/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.tileentity.music;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.tileentity.TileTotemic;
import pokefenn.totemic.util.EntityUtil;

public class TileWindChime
extends TileTotemic
implements ITickable {
    private boolean isPlaying = false;
    private int playingTimeLeft = 0;
    private int cooldown = 0;
    private boolean isCongested = false;

    public void func_73660_a() {
        if (this.isCongested) {
            if (this.field_145850_b.field_72995_K) {
                this.congestionParticles();
            }
            return;
        }
        if (this.isPlaying) {
            if (this.playingTimeLeft % 40 == 0) {
                if (!this.field_145850_b.field_72995_K) {
                    this.playMusic();
                } else {
                    this.soundAndParticles();
                }
            }
            --this.playingTimeLeft;
            if (this.playingTimeLeft <= 0) {
                this.setNotPlaying();
            }
        } else if (!this.field_145850_b.field_72995_K) {
            --this.cooldown;
            if (this.cooldown <= 0) {
                this.setPlaying(160);
            }
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K && this.checkForCongestion()) {
            this.isCongested = true;
        }
    }

    public void setPlaying(int time) {
        this.isPlaying = true;
        this.playingTimeLeft = time;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)ModBlocks.wind_chime, 0, time);
        }
        this.func_70296_d();
    }

    public void setNotPlaying() {
        this.isPlaying = false;
        if (!this.field_145850_b.field_72995_K) {
            this.cooldown = this.getRandomCooldown(this.field_145850_b.field_73012_v);
        }
        this.func_70296_d();
    }

    private int getRandomCooldown(Random rand) {
        return (int)(20.0 * (40.0 + 5.0 * rand.nextGaussian()));
    }

    private boolean checkForCongestion() {
        int count = 0;
        for (TileWindChime chime : EntityUtil.getTileEntitiesInRange(TileWindChime.class, this.field_145850_b, this.field_174879_c, 8, 8)) {
            if (chime != this && !chime.isCongested) {
                ++count;
            }
            if (count <= 2) continue;
            return true;
        }
        return false;
    }

    public boolean isCongested() {
        return this.isCongested;
    }

    public void tryUncongest() {
        if (this.isCongested) {
            this.isCongested = this.checkForCongestion();
            if (!this.isCongested) {
                this.markForUpdate();
            }
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    private void playMusic() {
        IBlockState upState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        int baseAmount = ModContent.windChime.getBaseOutput();
        int bonus = upState.func_177230_c().isLeaves(upState, (IBlockAccess)this.field_145850_b, this.field_174879_c.func_177984_a()) ? this.field_145850_b.field_73012_v.nextInt(3) : 0;
        Totemic.api.music().playMusic(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, null, ModContent.windChime, 5, baseAmount + bonus);
    }

    @SideOnly(value=Side.CLIENT)
    private void soundAndParticles() {
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModSounds.windChime, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        this.field_145850_b.func_175688_a(EnumParticleTypes.NOTE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.8, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    private void congestionParticles() {
        if (this.field_145850_b.func_82737_E() % 2L == 0L) {
            Random rand = this.field_145850_b.field_73012_v;
            this.field_145850_b.func_175688_a(EnumParticleTypes.CRIT, (double)((float)this.field_174879_c.func_177958_n() + rand.nextFloat()), (double)((float)this.field_174879_c.func_177956_o() + rand.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a("isPlaying", this.isPlaying);
        if (this.isPlaying) {
            tag.func_74768_a("playingTimeLeft", this.playingTimeLeft);
        }
        tag.func_74757_a("isCongested", this.isCongested);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.isPlaying = tag.func_74767_n("isPlaying");
        if (this.isPlaying) {
            this.playingTimeLeft = tag.func_74762_e("playingTimeLeft");
        }
        this.isCongested = tag.func_74767_n("isCongested");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74757_a("isPlaying", this.isPlaying);
        if (this.isPlaying) {
            tag.func_74768_a("playingTimeLeft", this.playingTimeLeft);
        } else {
            tag.func_74768_a("cooldown", this.cooldown);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isPlaying = tag.func_74767_n("isPlaying");
        if (this.isPlaying) {
            this.playingTimeLeft = tag.func_74762_e("playingTimeLeft");
        } else {
            this.cooldown = tag.func_74762_e("cooldown");
        }
    }
}

