/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.equipment;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.item.ItemTotemic;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemBase;
import pokefenn.totemic.tileentity.totem.TileTotemPole;
import pokefenn.totemic.util.EntityUtil;
import pokefenn.totemic.util.ItemUtil;

public class ItemMedicineBag
extends ItemTotemic {
    public static final String MED_BAG_TOTEM_KEY = "totem";
    public static final String MED_BAG_CHARGE_KEY = "charge";

    public ItemMedicineBag() {
        super("medicine_bag");
        this.func_77625_d(1);
    }

    public static Optional<TotemEffect> getEffect(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p()).map(tag -> (TotemEffect)TotemicRegistries.totemEffects().getValue(new ResourceLocation(tag.func_74779_i(MED_BAG_TOTEM_KEY))));
    }

    public static int getCharge(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(MED_BAG_CHARGE_KEY);
        }
        return 0;
    }

    public static int getMaxCharge(ItemStack stack) {
        int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        return (4 + 2 * unbreaking) * 60 * 20;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int charge;
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L) {
            this.tryCharge(stack, world, entity.func_180425_c());
        }
        if (stack.func_77960_j() != 0 && (charge = ItemMedicineBag.getCharge(stack)) != 0) {
            ItemMedicineBag.getEffect(stack).ifPresent(eff -> {
                if (world.func_82737_E() % (long)eff.getInterval() == 0L) {
                    eff.medicineBagEffect(world, (EntityPlayer)entity, stack, charge);
                    if (!world.field_72995_K && charge != -1) {
                        stack.func_77978_p().func_74768_a(MED_BAG_CHARGE_KEY, Math.max(charge - eff.getInterval(), 0));
                    }
                }
            });
        }
    }

    private void tryCharge(ItemStack stack, World world, BlockPos pos) {
        int maxCharge;
        int charge = ItemMedicineBag.getCharge(stack);
        if (charge < (maxCharge = ItemMedicineBag.getMaxCharge(stack)) && charge != -1) {
            ItemMedicineBag.getEffect(stack).ifPresent(effect -> {
                if (EntityUtil.getTileEntitiesInRange(TileTotemBase.class, world, pos, 6, 6).stream().anyMatch(tile -> tile.getState() instanceof StateTotemEffect && tile.getTotemEffectSet().contains((Object)effect))) {
                    stack.func_77978_p().func_74768_a(MED_BAG_CHARGE_KEY, Math.min(charge + maxCharge / 12, maxCharge));
                }
            });
        }
    }

    private ActionResult<ItemStack> openOrClose(ItemStack stack) {
        if (ItemMedicineBag.getEffect(stack).isPresent()) {
            stack.func_77964_b(stack.func_77960_j() == 0 ? 1 : 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return this.openOrClose(player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            ItemStack copyStack = player.func_184812_l_() ? stack.func_77946_l() : stack;
            ActionResult<ItemStack> result = this.openOrClose(copyStack);
            if (result.func_188397_a() == EnumActionResult.SUCCESS) {
                player.func_184611_a(hand, (ItemStack)result.func_188398_b());
            }
            return result.func_188397_a();
        }
        return this.trySetEffect(stack, player, world, pos, hand);
    }

    private EnumActionResult trySetEffect(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand) {
        TotemEffect effect;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTotemPole && (effect = ((TileTotemPole)tile).getEffect()) != null) {
            if (!effect.isPortable()) {
                if (world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.effectNotPortable", new Object[]{new TextComponentTranslation(effect.getUnlocalizedName(), new Object[0])}), true);
                }
                return EnumActionResult.FAIL;
            }
            ItemStack newStack = stack.func_77946_l();
            NBTTagCompound tag = ItemUtil.getOrCreateTag(newStack);
            tag.func_74778_a(MED_BAG_TOTEM_KEY, effect.getRegistryName().toString());
            if (tag.func_74762_e(MED_BAG_CHARGE_KEY) != -1) {
                tag.func_74768_a(MED_BAG_CHARGE_KEY, 0);
            }
            player.func_184611_a(hand, newStack);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemMedicineBag.getCharge(stack) != -1;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - Math.min((double)ItemMedicineBag.getCharge(stack) / (double)ItemMedicineBag.getMaxCharge(stack), 1.0);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.min((float)ItemMedicineBag.getCharge(stack) / (float)ItemMedicineBag.getMaxCharge(stack), 1.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String key = ItemMedicineBag.getCharge(stack) != -1 ? this.func_77658_a() : this.func_77658_a() + ".creative";
        return ItemMedicineBag.getEffect(stack).map(eff -> I18n.func_135052_a((String)(key + ".display"), (Object[])new Object[]{I18n.func_135052_a((String)eff.getUnlocalizedName(), (Object[])new Object[0])})).orElseGet(() -> I18n.func_135052_a((String)(key + ".name"), (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String key = ItemMedicineBag.getEffect(stack).isPresent() ? (ItemMedicineBag.getCharge(stack) != 0 ? (stack.func_77960_j() == 0 ? "tooltipClosed" : "tooltipOpen") : "tooltipEmpty") : "tooltip";
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + "." + key), (Object[])new Object[0]));
        if (flag.func_194127_a()) {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltipCharge"), (Object[])new Object[]{ItemMedicineBag.getCharge(stack), ItemMedicineBag.getMaxCharge(stack)}));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185307_s || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 8;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77983_a(MED_BAG_CHARGE_KEY, (NBTBase)new NBTTagInt(-1));
            subItems.add((Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }
}

