/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.datafix;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.chunk.NibbleArray;
import pokefenn.totemic.Totemic;

public class TotemWoodToTileEntity
implements IFixableData {
    public int func_188216_a() {
        return 1020;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        NBTTagCompound level = compound.func_74775_l("Level");
        NBTTagList tiles = level.func_150295_c("TileEntities", 10);
        NBTTagList sections = level.func_150295_c("Sections", 10);
        for (NBTBase t : tiles) {
            NBTTagCompound tile = (NBTTagCompound)t;
            String id = tile.func_74779_i("id");
            if (!"totemic:totem_base".equals(id) && !"totemic:totem_pole".equals(id)) continue;
            int x = tile.func_74762_e("x");
            int y = tile.func_74762_e("y");
            int z = tile.func_74762_e("z");
            NBTTagCompound section = this.getSectionForYCoord(sections, y);
            NibbleArray dataArr = new NibbleArray(section.func_74770_j("Data"));
            int arrX = x & 0xF;
            int arrY = y & 0xF;
            int arrZ = z & 0xF;
            int meta = dataArr.func_76582_a(arrX, arrY, arrZ);
            tile.func_74774_a("wood", (byte)meta);
            dataArr.func_76581_a(arrX, arrY, arrZ, EnumFacing.NORTH.func_176736_b());
            Totemic.logger.debug("Moved wood type from metadata to tile entity: {} at ({}, {}, {})", (Object)id, (Object)x, (Object)y, (Object)z);
        }
        return compound;
    }

    private NBTTagCompound getSectionForYCoord(NBTTagList sections, int y) {
        int sectionY = y >> 4;
        for (NBTBase s : sections) {
            NBTTagCompound section = (NBTTagCompound)s;
            if (section.func_74762_e("Y") != sectionY) continue;
            return section;
        }
        Totemic.logger.warn("No section present for y coordinate {}", (Object)y);
        return new NBTTagCompound();
    }
}

