/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pokefenn.totemic.block.BlockDecoPillar;
import pokefenn.totemic.lib.WoodVariant;
import pokefenn.totemic.tileentity.TileDecoPillar;

public class BlockDecoPillarBase
extends BlockDirectional
implements ITileEntityProvider {
    public static final PropertyEnum<WoodVariant> WOOD = BlockDecoPillar.WOOD;
    public static final PropertyBool STRIPPED = BlockDecoPillar.STRIPPED;
    private static final AxisAlignedBB X_BB = new AxisAlignedBB(0.0, 0.125, 0.125, 1.0, 0.875, 0.875);
    private static final AxisAlignedBB Y_BB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB Z_BB = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB BASE_UP_BB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.3125, 0.875);
    private static final AxisAlignedBB BASE_DOWN_BB = new AxisAlignedBB(0.125, 0.6875, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB BASE_SOUTH_BB = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.3125);
    private static final AxisAlignedBB BASE_NORTH_BB = new AxisAlignedBB(0.125, 0.125, 0.6875, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB BASE_EAST_BB = new AxisAlignedBB(0.0, 0.125, 0.125, 0.3125, 0.875, 0.875);
    private static final AxisAlignedBB BASE_WEST_BB = new AxisAlignedBB(0.6875, 0.125, 0.125, 1.0, 0.875, 0.875);
    private static final AxisAlignedBB POLE_UP_BB = new AxisAlignedBB(0.1875, 0.3125, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB POLE_DOWN_BB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.6875, 0.8125);
    private static final AxisAlignedBB POLE_SOUTH_BB = new AxisAlignedBB(0.1875, 0.1875, 0.3125, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB POLE_NORTH_BB = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.6875);
    private static final AxisAlignedBB POLE_EAST_BB = new AxisAlignedBB(0.3125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB POLE_WEST_BB = new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.6875, 0.8125, 0.8125);

    public BlockDecoPillarBase() {
        super(Material.field_151575_d);
        this.setRegistryName("wooden_pillar_base");
        this.func_149663_c("totemic:wooden_pillar_base");
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.UP).func_177226_a(WOOD, (Comparable)((Object)WoodVariant.OAK)).func_177226_a((IProperty)STRIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileDecoPillar tile = (TileDecoPillar)world.func_175625_s(pos);
        tile.setFromMetadata(stack.func_77960_j());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDecoPillar) {
            drops.add((Object)new ItemStack((Block)this, 1, ((TileDecoPillar)tile).getDropMetadata()));
        } else {
            drops.add((Object)new ItemStack((Block)this));
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileDecoPillar tile = (TileDecoPillar)world.func_175625_s(pos);
        return new ItemStack((Block)this, 1, tile.getDropMetadata());
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"tile.totemic:wooden_pillar.tooltip", (Object[])new Object[0]));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        int i;
        for (i = 0; i < WoodVariant.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, 2 * i));
        }
        for (i = 0; i < WoodVariant.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, 2 * i + 1));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                return Y_BB;
            }
            case SOUTH: 
            case NORTH: {
                return Z_BB;
            }
            case EAST: 
            case WEST: 
        }
        return X_BB;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            case UP: {
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_UP_BB);
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)POLE_UP_BB);
                break;
            }
            case DOWN: {
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_DOWN_BB);
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)POLE_DOWN_BB);
                break;
            }
            case SOUTH: {
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_SOUTH_BB);
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)POLE_SOUTH_BB);
                break;
            }
            case NORTH: {
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_NORTH_BB);
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)POLE_NORTH_BB);
                break;
            }
            case EAST: {
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_EAST_BB);
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)POLE_EAST_BB);
                break;
            }
            case WEST: {
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_WEST_BB);
                BlockDecoPillarBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)POLE_WEST_BB);
            }
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileDecoPillar) {
            TileDecoPillar tile = (TileDecoPillar)world.func_175625_s(pos);
            if (tile.isStripped() || ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176740_k() == EnumFacing.Axis.Y) {
                return tile.getWoodType().getMapColor();
            }
            return BlockDecoPillar.getBarkColor(tile.getWoodType());
        }
        return MapColor.field_151663_o;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, WOOD, STRIPPED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDecoPillar) {
            TileDecoPillar tdp = (TileDecoPillar)tile;
            return state.func_177226_a(WOOD, (Comparable)((Object)tdp.getWoodType())).func_177226_a((IProperty)STRIPPED, (Comparable)Boolean.valueOf(tdp.isStripped()));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face.func_176740_k() == ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176740_k()) {
            return BlockFaceShape.CENTER_BIG;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176740_k() == EnumFacing.Axis.Y;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileDecoPillar tile = new TileDecoPillar();
        tile.setWoodType((WoodVariant)((Object)state.func_177229_b(WOOD)));
        tile.setStripped((Boolean)state.func_177229_b((IProperty)STRIPPED));
        return tile;
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileDecoPillar();
    }
}

