/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips;

import java.util.List;
import net.darkhax.tips.TipsAPI;
import net.darkhax.tips.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="tips", name="Tips", version="1.0.9", clientSideOnly=true, certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", guiFactory="net.darkhax.tips.client.gui.GuiFactoryTip", acceptedMinecraftVersions="[1.12.2]")
public class TipsMod {
    public static final String MODID = "tips";
    public static final Logger LOG = LogManager.getLogger((String)"Tips");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        TipsAPI.addTips(TipsMod::addDefaultModTips);
        TipsAPI.addTips(TipsMod::addConfigTips);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.syncConfigData();
    }

    @Mod.EventHandler
    public void onClientLoadComplete(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(manager -> TipsAPI.reloadTips());
    }

    private static void addDefaultModTips(List<String> tips) {
        if (Config.allowDefaultTips) {
            for (ModContainer container : Loader.instance().getActiveModList()) {
                String translationTip;
                String translationKey;
                String baseKey = "mods.tips." + container.getModId() + ".";
                for (int i = 1; i < 10000 && !(translationKey = baseKey + i).equals(translationTip = I18n.func_135052_a((String)translationKey, (Object[])new Object[0])); ++i) {
                    if (MODID.equals(container.getModId())) {
                        tips.add(translationTip);
                        continue;
                    }
                    tips.add(translationTip + "#SPLIT#" + container.getName() + " " + I18n.func_135052_a((String)"tips.gui.title", (Object[])new Object[0]));
                }
            }
        }
    }

    private static void addConfigTips(List<String> tips) {
        for (String configTip : Config.tips) {
            tips.add(I18n.func_135052_a((String)configTip, (Object[])new Object[0]));
        }
    }
}

