/*
 * Decompiled with CFR 0.152.
 */
package youyihj.tinkersoredictcache.mixins;

import java.io.File;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import youyihj.tinkersoredictcache.Configuration;
import youyihj.tinkersoredictcache.OreDictRecipesState;
import youyihj.tinkersoredictcache.TinkersOreDictCache;

@Mixin(value={TinkerSmeltery.class}, remap=false)
public class MixinTinkerSmeltery {
    @Inject(method={"registerRecipeOredictMelting"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectRegisterRecipeOredictMeltingHead(CallbackInfo ci) {
        if (Configuration.disableOreDictMelting) {
            ci.cancel();
            return;
        }
        if (OreDictRecipesState.getCurrentState().isRead()) {
            NBTTagCompound cacheNBT = TinkersOreDictCache.INSTANCE.cacheNBT;
            NBTTagList recipeList = cacheNBT.func_150295_c("Recipes", 10);
            for (NBTBase nbtBase : recipeList) {
                NBTTagCompound compound = (NBTTagCompound)nbtBase;
                ItemStack item = new ItemStack(compound.func_74775_l("item"));
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluid"));
                if (item.func_190926_b() || fluid == null) continue;
                TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((ItemStack)item, (int)fluid.amount), fluid));
            }
            ci.cancel();
        }
    }

    @Inject(method={"registerRecipeOredictMelting"}, at={@At(value="TAIL")})
    private static void injectRegisterRecipeOredictMeltingTail(CallbackInfo ci) {
        if (OreDictRecipesState.getCurrentState().isScan()) {
            try {
                File file = TinkersOreDictCache.INSTANCE.cacheFile;
                if (!file.exists()) {
                    file.createNewFile();
                }
                CompressedStreamTools.func_74795_b((NBTTagCompound)TinkersOreDictCache.INSTANCE.cacheNBT, (File)TinkersOreDictCache.INSTANCE.cacheFile);
            }
            catch (IOException e) {
                TinkersOreDictCache.INSTANCE.logger.error("failed to write cache file", (Throwable)e);
            }
        }
    }

    @Redirect(method={"registerRecipeOredictMelting"}, at=@At(value="INVOKE", target="Lslimeknights/tconstruct/library/TinkerRegistry;registerMelting(Lslimeknights/tconstruct/library/smeltery/MeltingRecipe;)V"))
    private static void redirectRegisterMelting(MeltingRecipe recipe) {
        TinkerRegistry.registerMelting((MeltingRecipe)recipe);
        if (OreDictRecipesState.getCurrentState().isScan()) {
            NBTTagCompound cacheNBT = TinkersOreDictCache.INSTANCE.cacheNBT;
            if (!cacheNBT.func_74764_b("Recipes")) {
                cacheNBT.func_74782_a("Recipes", (NBTBase)new NBTTagList());
            }
            NBTTagList recipeList = cacheNBT.func_150295_c("Recipes", 10);
            NBTTagCompound recipeNBT = new NBTTagCompound();
            ItemStack input = (ItemStack)recipe.input.getInputs().get(0);
            FluidStack output = recipe.output;
            if (!input.func_190926_b() && FluidRegistry.isFluidRegistered((Fluid)output.getFluid())) {
                recipeNBT.func_74782_a("item", (NBTBase)input.serializeNBT());
                recipeNBT.func_74782_a("fluid", (NBTBase)MixinTinkerSmeltery.fluidToNBT(output));
                recipeList.func_74742_a((NBTBase)recipeNBT);
            }
        }
    }

    private static NBTTagCompound fluidToNBT(FluidStack fluidStack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("FluidName", fluidStack.getFluid().getName());
        nbt.func_74768_a("Amount", fluidStack.amount);
        if (fluidStack.tag != null) {
            nbt.func_74782_a("Tag", (NBTBase)fluidStack.tag);
        }
        return nbt;
    }
}

