/*
 * Decompiled with CFR 0.152.
 */
package youyihj.tinkersoredictcache;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import youyihj.tinkersoredictcache.OreDictRecipesState;

@Mod(modid="tinkersoredictcache", name="TinkersOreDictCache", version="1.0", dependencies="required-after:tconstruct", acceptedMinecraftVersions="[1.12.2]")
public class TinkersOreDictCache {
    public static final String MOD_ID = "tinkersoredictcache";
    public static final String MOD_NAME = "TinkersOreDictCache";
    public static final String VERSION = "1.0";
    public static final String DEPENDENCIES = "required-after:tconstruct";
    public Logger logger;
    public final File cacheFile = new File("config/tinker_ore_dict_melting_cache.dat");
    public NBTTagCompound cacheNBT = new NBTTagCompound();
    @Mod.Instance
    public static TinkersOreDictCache INSTANCE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NBTTagList modsNBT;
        this.logger = event.getModLog();
        OreDictRecipesState.setCurrentState(this.cacheFile.exists() ? OreDictRecipesState.READ : OreDictRecipesState.SCAN);
        if (OreDictRecipesState.getCurrentState().isRead()) {
            try {
                this.cacheNBT = Objects.requireNonNull(CompressedStreamTools.func_74797_a((File)this.cacheFile));
            }
            catch (IOException e) {
                this.logger.error("failed to read cache file! We will rescan all recipes...", (Throwable)e);
                OreDictRecipesState.setCurrentState(OreDictRecipesState.SCAN);
            }
            modsNBT = this.cacheNBT.func_150295_c("Mods", 8);
            if (!this.hasSameElements(this.getInstalledModIds(), StreamSupport.stream(modsNBT.spliterator(), false).map(nbt -> ((NBTTagString)nbt).func_150285_a_()).collect(Collectors.toList()))) {
                this.logger.info("Detected mods installed are different from the last starting. We will rescan all recipes...");
                this.cacheNBT = new NBTTagCompound();
                OreDictRecipesState.setCurrentState(OreDictRecipesState.SCAN);
            }
        }
        if (OreDictRecipesState.getCurrentState().isScan()) {
            modsNBT = new NBTTagList();
            this.getInstalledModIds().stream().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)modsNBT).func_74742_a(arg_0));
            this.cacheNBT.func_74782_a("Mods", (NBTBase)modsNBT);
        }
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        this.cacheNBT = null;
    }

    private Collection<String> getInstalledModIds() {
        return Loader.instance().getIndexedModList().keySet();
    }

    private <T> boolean hasSameElements(Collection<T> first, Collection<T> second) {
        if (first.size() != second.size()) {
            return false;
        }
        HashSet<T> collection = new HashSet<T>(first);
        collection.addAll(second);
        return collection.size() == first.size();
    }
}

